/*
 * Decompiled with CFR 0.152.
 */
package org.pf.security.authentication;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.pf.security.authentication.AbstractAuthenticator;
import org.pf.security.authentication.LocationCredentials;
import org.pf.text.StringUtil;
import org.pf.text.Version;

public class AutoAuthenticationManager
extends Authenticator {
    protected static final Version HOST_SUPPORT_VERSION = new Version("1.4");
    protected static final Version JAVA_VERSION = new Version(System.getProperty("java.version"));
    private static AutoAuthenticationManager soleInstance = new AutoAuthenticationManager();
    private Map locationCredentials = new HashMap();
    private LocationCredentials activeCredentials = null;
    private AbstractAuthenticator fallbackAuthenticator = null;

    protected Map getLocationCredentials() {
        return this.locationCredentials;
    }

    protected void setLocationCredentials(Map newValue) {
        this.locationCredentials = newValue;
    }

    protected LocationCredentials getActiveCredentials() {
        return this.activeCredentials;
    }

    protected void setActiveCredentials(LocationCredentials newValue) {
        this.activeCredentials = newValue;
    }

    public AbstractAuthenticator getFallbackAuthenticator() {
        return this.fallbackAuthenticator;
    }

    public void setFallbackAuthenticator(AbstractAuthenticator newValue) {
        this.fallbackAuthenticator = newValue;
    }

    public static AutoAuthenticationManager install() {
        Authenticator.setDefault(AutoAuthenticationManager.instance());
        return AutoAuthenticationManager.instance();
    }

    public static void uninstall() {
        Authenticator.setDefault(null);
    }

    public static AutoAuthenticationManager instance() {
        return soleInstance;
    }

    private AutoAuthenticationManager() {
    }

    public boolean aboutToAccess(String url) {
        LocationCredentials credentials = this.findCredentialsFor(url);
        this.setActiveCredentials(credentials);
        return this.hasActiveCredentials();
    }

    public boolean aboutToAccess(URL url) {
        if (url == null) {
            this.setActiveCredentials(null);
            return this.hasActiveCredentials();
        }
        return this.aboutToAccess(url.toString());
    }

    public void register(String id, LocationCredentials credentials) {
        if (!this.str().isNullOrBlank(id) && credentials != null) {
            this.getLocationCredentials().put(id, credentials);
        }
    }

    public LocationCredentials remove(String id) {
        if (this.str().isNullOrBlank(id)) {
            return null;
        }
        return (LocationCredentials)this.getLocationCredentials().remove(id);
    }

    public void reset() {
        this.setLocationCredentials(new HashMap());
        this.setFallbackAuthenticator(null);
        this.setActiveCredentials(null);
    }

    protected PasswordAuthentication getPasswordAuthentication() {
        PasswordAuthentication auth = this.hasActiveCredentials() ? this.getActiveCredentials().getPasswordAuthentication() : this.findPasswordAuthenticationForRealm();
        if (auth == null && this.getFallbackAuthenticator() != null) {
            this.fillFallbackAuthenticator();
            auth = this.getFallbackAuthenticator().getPasswordAuthentication();
        }
        this.setActiveCredentials(null);
        return auth;
    }

    protected PasswordAuthentication findPasswordAuthenticationForRealm() {
        LocationCredentials creds = this.findCredentialsForRealm();
        if (creds == null) {
            return null;
        }
        return creds.getPasswordAuthentication();
    }

    protected LocationCredentials getCredentials(String id) {
        if (this.str().isNullOrBlank(id)) {
            return null;
        }
        return (LocationCredentials)this.getLocationCredentials().get(id);
    }

    protected LocationCredentials findCredentialsFor(String url) {
        if (this.str().isNullOrBlank(url)) {
            return null;
        }
        Iterator iter = this.getLocationCredentials().values().iterator();
        while (iter.hasNext()) {
            LocationCredentials creds = (LocationCredentials)iter.next();
            if (!creds.appliesToURL(url)) continue;
            return creds;
        }
        return null;
    }

    protected LocationCredentials findCredentialsForRealm() {
        if (this.isBasicHttp()) {
            return this.findCredentialsForRealm(this.getRequestingPrompt());
        }
        return null;
    }

    protected LocationCredentials findCredentialsForRealm(String realm) {
        if (this.str().isNullOrBlank(realm)) {
            return null;
        }
        Iterator iter = this.getLocationCredentials().values().iterator();
        while (iter.hasNext()) {
            LocationCredentials creds = (LocationCredentials)iter.next();
            if (!creds.appliesToRealm(realm)) continue;
            return creds;
        }
        return null;
    }

    protected void fillFallbackAuthenticator() {
        AbstractAuthenticator auth = this.getFallbackAuthenticator();
        if (this.supportsHostNames()) {
            auth.setRequestingHost(this.getRequestingHost());
        } else {
            auth.setRequestingHost(null);
        }
        auth.setRequestingPort(this.getRequestingPort());
        auth.setRequestingPrompt(this.getRequestingPrompt());
        auth.setRequestingProtocol(this.getRequestingProtocol());
        auth.setRequestingScheme(this.getRequestingScheme());
        auth.setRequestingSite(this.getRequestingSite());
    }

    protected boolean hasActiveCredentials() {
        return this.getActiveCredentials() != null;
    }

    protected boolean isBasicHttp() {
        return "Basic".equalsIgnoreCase(this.getRequestingScheme()) && "http".equalsIgnoreCase(this.getRequestingProtocol());
    }

    protected boolean supportsHostNames() {
        return !JAVA_VERSION.isLessThan(HOST_SUPPORT_VERSION);
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

