/*
 * Decompiled with CFR 0.152.
 */
package org.pf.security.authentication;

import java.net.PasswordAuthentication;
import org.pf.text.StringPattern;
import org.pf.text.StringPatternCollection;
import org.pf.text.StringUtil;

public class LocationCredentials {
    private String realmName = null;
    private StringPatternCollection locationPatterns = null;
    private String userId = null;
    private PasswordAuthentication credentials = null;

    protected String getRealmName() {
        return this.realmName;
    }

    protected void setRealmName(String newValue) {
        this.realmName = newValue;
    }

    protected StringPatternCollection getLocationPatterns() {
        return this.locationPatterns;
    }

    protected void setLocationPatterns(StringPatternCollection newValue) {
        this.locationPatterns = newValue;
    }

    protected String getUserId() {
        return this.userId;
    }

    protected void setUserId(String newValue) {
        this.userId = newValue;
    }

    protected PasswordAuthentication getCredentials() {
        return this.credentials;
    }

    protected void setCredentials(PasswordAuthentication newValue) {
        this.credentials = newValue;
    }

    public LocationCredentials(String userId, String password) {
        this.setUserId(userId);
        this.setLocationPatterns(new StringPatternCollection());
        if (password != null) {
            this.setCredentials(new PasswordAuthentication(userId, password.toCharArray()));
        }
    }

    public LocationCredentials(String realm, String userId, String password) {
        this(userId, password);
        this.setRealm(realm);
    }

    public PasswordAuthentication getPasswordAuthentication() {
        if (this.getCredentials() == null) {
            this.fillCredentials();
        }
        return this.getCredentials();
    }

    public String getRealm() {
        return this.getRealmName();
    }

    public void setRealm(String realm) {
        this.setRealmName(realm);
    }

    public void addPattern(String pattern) {
        if (!this.str().isNullOrBlank(pattern)) {
            StringPattern strPattern = StringPattern.create(pattern);
            this.addPattern(strPattern);
        }
    }

    public void addPattern(StringPattern pattern) {
        if (pattern != null) {
            this.getLocationPatterns().add(pattern);
        }
    }

    public boolean appliesTo(String realm, String url) {
        boolean applies = true;
        if (realm == null && url == null) {
            return false;
        }
        if (realm != null) {
            boolean bl = applies = applies && this.appliesToRealm(realm);
        }
        if (url != null) {
            applies = applies && this.appliesToURL(url);
        }
        return applies;
    }

    public boolean appliesToURL(String url) {
        if (url == null) {
            return false;
        }
        return this.getLocationPatterns().matchesAny(url);
    }

    public boolean appliesToRealm(String realm) {
        if (realm == null || this.getRealm() == null) {
            return false;
        }
        return this.getRealm().equalsIgnoreCase(realm);
    }

    protected void fillCredentials() {
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

