/*
 * Decompiled with CFR 0.152.
 */
package org.pf.settings.impl;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.pf.settings.impl.KeyValuePair;
import org.pf.settings.impl.SettingsElement;

class Category
extends SettingsElement {
    private static final String DEFAULT_CATEGORY_NAME = "";
    private List keysAndValues = new Vector();

    private List getKeysAndValues() {
        return this.keysAndValues;
    }

    Category(String aName, boolean checkCase) {
        super(aName == null ? DEFAULT_CATEGORY_NAME : aName, checkCase);
    }

    protected boolean matchesName(String aName) {
        if (aName == null && this.isDefaultCategory()) {
            return true;
        }
        return super.matchesName(aName);
    }

    void changeCaseSensitive(boolean isCaseSensitive) {
        this.setCaseSensitive(isCaseSensitive);
        Iterator keyValues = this.getKeysAndValues().iterator();
        while (keyValues.hasNext()) {
            KeyValuePair keyValue = (KeyValuePair)keyValues.next();
            keyValue.changeCaseSensitive(isCaseSensitive);
        }
    }

    boolean isDefaultCategory() {
        return this.getName().equals(DEFAULT_CATEGORY_NAME);
    }

    String getValueOf(String keyName) {
        String resultValue = null;
        KeyValuePair setting = null;
        setting = this.getSettingNamed(keyName);
        if (setting != null) {
            resultValue = setting.getValue();
        }
        return resultValue;
    }

    void setValueOf(String keyName, String value) {
        KeyValuePair setting = null;
        setting = this.getSettingNamed(keyName);
        if (setting == null) {
            setting = this.createNewSetting(keyName);
            this.getKeysAndValues().add(setting);
        }
        setting.setValue(value);
    }

    String[] getKeyNames() {
        Iterator list = null;
        KeyValuePair setting = null;
        String[] keyNames = null;
        int counter = 0;
        keyNames = new String[this.getKeysAndValues().size()];
        list = this.getKeysAndValues().iterator();
        while (list.hasNext()) {
            setting = (KeyValuePair)list.next();
            keyNames[counter] = setting.getName();
            ++counter;
        }
        return keyNames;
    }

    void removeKey(String keyName) {
        KeyValuePair setting = null;
        setting = this.getSettingNamed(keyName);
        if (setting != null) {
            this.getKeysAndValues().remove(setting);
        }
    }

    KeyValuePair getSettingNamed(String keyName) {
        Iterator list = null;
        KeyValuePair setting = null;
        list = this.getKeysAndValues().iterator();
        while (list.hasNext()) {
            setting = (KeyValuePair)list.next();
            if (!setting.matchesName(keyName)) continue;
            return setting;
        }
        return null;
    }

    KeyValuePair createNewSetting(String aName) {
        return new KeyValuePair(aName, this.getCaseSensitive());
    }
}

