/*
 * Decompiled with CFR 0.152.
 */
package org.pf.settings.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pf.settings.impl.GenericNamedObject;
import org.pf.settings.impl.SettingsElement;

abstract class GenericCategory
extends SettingsElement {
    protected static final String DEFAULT_CATEGORY_NAME = "";
    private List keysAndValues = new ArrayList();

    protected List getKeysAndValues() {
        return this.keysAndValues;
    }

    protected void setKeysAndValues(List aValue) {
        this.keysAndValues = aValue;
    }

    protected GenericCategory(String aName, boolean checkCase) {
        super(aName == null ? DEFAULT_CATEGORY_NAME : aName, checkCase);
    }

    protected abstract GenericNamedObject createNewSetting(String var1);

    protected void changeCaseSensitive(boolean isCaseSensitive) {
        this.setCaseSensitive(isCaseSensitive);
        Iterator keyValues = this.getKeysAndValues().iterator();
        while (keyValues.hasNext()) {
            GenericNamedObject keyValue = (GenericNamedObject)keyValues.next();
            keyValue.changeCaseSensitive(isCaseSensitive);
        }
    }

    protected boolean isDefaultCategory() {
        return this.getName().equals(DEFAULT_CATEGORY_NAME);
    }

    protected String getValueOf(String keyName) {
        String resultValue = null;
        GenericNamedObject setting = null;
        setting = this.getSettingNamed(keyName);
        if (setting != null) {
            resultValue = setting.getValue();
        }
        return resultValue;
    }

    protected void setValueOf(String keyName, String value) {
        GenericNamedObject setting = null;
        setting = this.getSettingNamed(keyName);
        if (setting == null) {
            setting = this.createAndAddNewSetting(keyName);
        }
        setting.setValue(value);
    }

    protected String[] getKeyNames() {
        Iterator list = null;
        GenericNamedObject setting = null;
        String[] keyNames = null;
        int counter = 0;
        keyNames = new String[this.getKeysAndValues().size()];
        list = this.getKeysAndValues().iterator();
        while (list.hasNext()) {
            setting = (GenericNamedObject)list.next();
            keyNames[counter] = setting.getName();
            ++counter;
        }
        return keyNames;
    }

    protected void removeKey(String keyName) {
        GenericNamedObject setting = null;
        setting = this.getSettingNamed(keyName);
        if (setting != null) {
            this.getKeysAndValues().remove(setting);
        }
    }

    protected boolean matchesName(String aName) {
        if (aName == null && this.isDefaultCategory()) {
            return true;
        }
        return super.matchesName(aName);
    }

    protected GenericNamedObject getSettingNamed(String keyName) {
        Iterator list = null;
        GenericNamedObject setting = null;
        list = this.getKeysAndValues().iterator();
        while (list.hasNext()) {
            setting = (GenericNamedObject)list.next();
            if (!setting.matchesName(keyName)) continue;
            return setting;
        }
        return null;
    }

    protected GenericNamedObject createAndAddNewSetting(String keyName) {
        GenericNamedObject setting = this.createNewSetting(keyName);
        this.getKeysAndValues().add(setting);
        return setting;
    }

    protected String inspectString() {
        return "Category(\"" + this.getName() + "\")";
    }
}

