/*
 * Decompiled with CFR 0.152.
 */
package org.pf.settings.impl;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.pf.settings.CaseSensitivity;
import org.pf.settings.ReadOnlySettings;
import org.pf.settings.Settings;
import org.pf.settings.impl.GenericCategory;
import org.pf.util.CollectionUtil;

public abstract class GenericSettingsImpl
implements Settings,
CaseSensitivity {
    public static final String DEFAULT_CATEGORY_NAME = "";
    private String name = null;
    private List categories = new ArrayList();
    private ReadOnlySettings defaultSettings = null;
    private boolean caseSensitive = true;

    protected List getCategories() {
        return this.categories;
    }

    protected void setCategories(List aValue) {
        this.categories = aValue;
    }

    protected ReadOnlySettings defaultSettings() {
        return this.defaultSettings;
    }

    public void defaultSettings(ReadOnlySettings newValue) {
        this.defaultSettings = newValue;
    }

    protected boolean caseSensitive() {
        return this.caseSensitive;
    }

    protected void caseSensitive(boolean newValue) {
        this.caseSensitive = newValue;
    }

    public GenericSettingsImpl() {
    }

    public GenericSettingsImpl(String aName) {
        this();
        this.setName(aName);
    }

    public String getValueOf(String categoryName, String keyName) {
        String resultValue = null;
        resultValue = this.basicGetValueOf(categoryName, keyName);
        if (resultValue == null && this.hasDefaults()) {
            return this.getDefaults().getValueOf(categoryName, keyName);
        }
        return resultValue;
    }

    public String getValueOf(String keyName) {
        return this.getValueOf(null, keyName);
    }

    public void setValueOf(String categoryName, String keyName, String value) {
        GenericCategory category = null;
        category = this.getCategoryNamed(categoryName);
        if (category == null) {
            category = this.createAndAddCategory(categoryName);
        }
        category.setValueOf(keyName, value);
    }

    public void setValueOf(String keyName, String value) {
        this.setValueOf(null, keyName, value);
    }

    public String[] getCategoryNames() {
        List categoryNames = this.getCategoryNameList();
        return categoryNames.toArray(new String[categoryNames.size()]);
    }

    public String[] getKeyNamesOf(String categoryName) {
        List keyNames = this.basicGetKeyNamesOf(categoryName);
        if (this.hasDefaults()) {
            this.util().addAll(keyNames, this.getDefaults().getKeyNamesOf(categoryName));
        }
        return keyNames.toArray(new String[keyNames.size()]);
    }

    public String[] getKeyNamesOfDefaultCategory() {
        return this.getKeyNamesOf(null);
    }

    public void removeKey(String categoryName, String keyName) {
        GenericCategory category = null;
        category = this.getCategoryNamed(categoryName);
        if (category != null) {
            category.removeKey(keyName);
        }
    }

    public void removeKey(String keyName) {
        this.removeKey(null, keyName);
    }

    public void removeCategory(String categoryName) {
        GenericCategory category = null;
        category = this.getCategoryNamed(categoryName);
        if (category != null) {
            this.getCategories().remove(category);
        }
    }

    public void removeDefaultCategory() {
        this.removeCategory(null);
    }

    public String getSettingsNameOf(String categoryName, String keyName) {
        if (this.basicGetValueOf(categoryName, keyName) != null) {
            return this.getName();
        }
        if (this.hasDefaults()) {
            return this.getDefaults().getSettingsNameOf(categoryName, keyName);
        }
        return null;
    }

    public String getSettingsNameOf(String keyName) {
        return this.getSettingsNameOf(null, keyName);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String aName) {
        this.name = aName;
    }

    public boolean getCaseSensitive() {
        return this.caseSensitive;
    }

    public void setCaseSensitive(boolean isCaseSensitive) {
        this.caseSensitive(isCaseSensitive);
        Iterator iterator = this.getCategories().iterator();
        while (iterator.hasNext()) {
            GenericCategory category = (GenericCategory)iterator.next();
            category.changeCaseSensitive(isCaseSensitive);
        }
        if (this.hasDefaults() && this.getDefaults() instanceof CaseSensitivity) {
            CaseSensitivity defaults = (CaseSensitivity)((Object)this.getDefaults());
            defaults.setCaseSensitive(isCaseSensitive);
        }
    }

    public ReadOnlySettings getDefaults() {
        return this.defaultSettings();
    }

    public void setDefaults(ReadOnlySettings defaults) {
        this.defaultSettings(defaults);
    }

    protected abstract GenericCategory createNewCategory(String var1);

    protected List getCategoryNameList() {
        List categoryNames = this.basicGetCategoryNames();
        if (this.hasDefaults()) {
            this.util().addAllNew(categoryNames, this.getDefaults().getCategoryNames());
        }
        return categoryNames;
    }

    protected List getKeyNameListOf(String categoryName) {
        List keyNames = this.basicGetKeyNamesOf(categoryName);
        if (this.hasDefaults()) {
            this.util().addAllNew(keyNames, this.getDefaults().getKeyNamesOf(categoryName));
        }
        return keyNames;
    }

    protected String basicGetValueOf(String categoryName, String keyName) {
        String resultValue = null;
        GenericCategory category = null;
        category = this.getCategoryNamed(categoryName);
        if (category != null) {
            resultValue = category.getValueOf(keyName);
        }
        return resultValue;
    }

    protected List basicGetCategoryNames() {
        Iterator list = null;
        GenericCategory category = null;
        ArrayList<String> categoryNames = null;
        categoryNames = new ArrayList<String>(this.getCategories().size());
        list = this.getCategories().iterator();
        while (list.hasNext()) {
            category = (GenericCategory)list.next();
            categoryNames.add(category.getName());
        }
        return categoryNames;
    }

    protected List basicGetKeyNamesOf(String categoryName) {
        GenericCategory category = null;
        ArrayList keyNames = new ArrayList();
        category = this.getCategoryNamed(categoryName);
        if (category != null) {
            this.util().addAll(keyNames, category.getKeyNames());
        }
        return keyNames;
    }

    protected boolean hasDefaults() {
        return this.defaultSettings() != null;
    }

    protected GenericCategory getCategoryNamed(String categoryName) {
        Iterator list = null;
        GenericCategory category = null;
        list = this.getCategories().iterator();
        while (list.hasNext()) {
            category = (GenericCategory)list.next();
            if (!category.matchesName(categoryName)) continue;
            return category;
        }
        return null;
    }

    protected GenericCategory createAndAddCategory(String categoryName) {
        GenericCategory category = this.createNewCategory(categoryName);
        this.getCategories().add(category);
        return category;
    }

    protected CollectionUtil util() {
        return CollectionUtil.current();
    }

    protected String inspectString() {
        return "Settings(\"" + this.getName() + "\")";
    }
}

