/*
 * Decompiled with CFR 0.152.
 */
package org.pf.settings.impl;

import org.pf.settings.MultiValueSettings;
import org.pf.settings.impl.GenericCategory;
import org.pf.settings.impl.GenericSettingsImpl;
import org.pf.settings.impl.MultiValueCategory;

public class MultiValueSettingsImpl
extends GenericSettingsImpl
implements MultiValueSettings {
    public MultiValueSettingsImpl() {
    }

    public MultiValueSettingsImpl(String aName) {
        super(aName);
    }

    public String[] getValuesOf(String categoryName, String keyName) {
        String[] resultValues = null;
        resultValues = this.basicGetValuesOf(categoryName, keyName);
        if (resultValues == null && this.hasDefaults()) {
            if (this.hasMultiValueDefaults()) {
                return this.getMultiValueDefaults().getValuesOf(categoryName, keyName);
            }
            String value = this.getDefaults().getValueOf(categoryName, keyName);
            if (value == null) {
                return null;
            }
            return new String[]{value};
        }
        return resultValues;
    }

    public String[] getValuesOf(String keyName) {
        return this.getValuesOf(null, keyName);
    }

    public void setValuesOf(String categoryName, String keyName, String[] values) {
        MultiValueCategory category = this.getMultiValueCategoryNamed(categoryName);
        category.setValuesOf(keyName, values);
    }

    public void setValuesOf(String keyName, String[] values) {
        this.setValuesOf(null, keyName, values);
    }

    public void addValue(String categoryName, String keyName, String value) {
        MultiValueCategory category = this.getMultiValueCategoryNamed(categoryName);
        category.addValue(keyName, value);
    }

    public void addValue(String keyName, String value) {
        this.addValue(null, keyName, value);
    }

    public void addValues(String categoryName, String keyName, String[] values) {
        MultiValueCategory category = this.getMultiValueCategoryNamed(categoryName);
        category.addValues(keyName, values);
    }

    public void addValues(String keyName, String[] values) {
        this.addValues(null, keyName, values);
    }

    public void removeValue(String categoryName, String keyName, String value) {
        MultiValueCategory category = this.getMultiValueCategoryNamed(categoryName);
        category.removeValueFrom(keyName, value);
    }

    public void removeValue(String keyName, String value) {
        this.removeValue(null, keyName, value);
    }

    protected String[] basicGetValuesOf(String categoryName, String keyName) {
        String[] resultValues = null;
        MultiValueCategory category = null;
        category = this.findCategoryNamed(categoryName);
        if (category != null) {
            resultValues = category.getValuesOf(keyName);
        }
        return resultValues;
    }

    protected MultiValueCategory getMultiValueCategoryNamed(String categoryName) {
        GenericCategory category = null;
        category = this.getCategoryNamed(categoryName);
        if (category == null) {
            category = this.createAndAddCategory(categoryName);
        }
        return (MultiValueCategory)category;
    }

    protected MultiValueCategory findCategoryNamed(String categoryName) {
        GenericCategory category = this.getCategoryNamed(categoryName);
        if (category instanceof MultiValueCategory) {
            return (MultiValueCategory)category;
        }
        return null;
    }

    protected MultiValueSettings getMultiValueDefaults() {
        return (MultiValueSettings)this.getDefaults();
    }

    protected boolean hasMultiValueDefaults() {
        return this.getDefaults() instanceof MultiValueSettings;
    }

    protected GenericCategory createNewCategory(String categoryName) {
        return new MultiValueCategory(categoryName, this.getCaseSensitive());
    }
}

