/*
 * Decompiled with CFR 0.152.
 */
package org.pf.settings.impl;

import java.io.File;
import java.util.Observable;
import org.pf.settings.ReadOnlySettings;
import org.pf.settings.Settings;
import org.pf.settings.SettingsFileReader;
import org.pf.settings.impl.ReloadableSettingsException;
import org.pf.settings.impl.SettingsImpl;
import org.pf.util.Trigger;
import org.pf.util.TriggerClient;

public class ReloadableSettings
extends Observable
implements ReadOnlySettings,
TriggerClient {
    static final boolean DEBUG = false;
    private static int UNKNOWN_FILE_TIMESTAMP = 0;
    private volatile ReadOnlySettings settings = null;
    private Trigger fileCheckTrigger = null;
    private boolean fileMustExist = true;
    private File file = null;
    private SettingsFileReader reader = null;
    private long fileTimestamp = UNKNOWN_FILE_TIMESTAMP;

    protected ReadOnlySettings getSettings() {
        return this.settings;
    }

    protected void setSettings(ReadOnlySettings newValue) {
        this.settings = newValue;
    }

    protected Trigger getFileCheckTrigger() {
        return this.fileCheckTrigger;
    }

    protected void setFileCheckTrigger(Trigger newValue) {
        this.fileCheckTrigger = newValue;
    }

    protected boolean fileMustExist() {
        return this.fileMustExist;
    }

    protected void fileMustExist(boolean newValue) {
        this.fileMustExist = newValue;
    }

    protected File getFile() {
        return this.file;
    }

    protected void setFile(File newValue) {
        this.file = newValue;
    }

    protected SettingsFileReader getReader() {
        return this.reader;
    }

    protected void setReader(SettingsFileReader newValue) {
        this.reader = newValue;
    }

    protected long getFileTimestamp() {
        return this.fileTimestamp;
    }

    protected void setFileTimestamp(long newValue) {
        this.fileTimestamp = newValue;
    }

    public ReloadableSettings(long checkInterval, SettingsFileReader reader) throws ReloadableSettingsException {
        this(checkInterval, reader, true);
    }

    public ReloadableSettings(long checkInterval, SettingsFileReader reader, boolean mustExist) throws ReloadableSettingsException {
        if (reader == null) {
            throw this.invalidParameter("reader");
        }
        String filename = reader.getFileName();
        if (filename == null) {
            throw this.invalidParameter("reader.getFileName()");
        }
        if (checkInterval < 1L) {
            throw this.invalidParameter("checkInterval");
        }
        this.fileMustExist(mustExist);
        this.checkAndRememberFile(filename, mustExist);
        this.setReader(reader);
        this.loadSettings();
        this.clearChanged();
        this.startTrigger(checkInterval);
    }

    public String getName() {
        return this.getSettings().getName();
    }

    public void setName(String aName) {
        this.getSettings().setName(aName);
    }

    public String getValueOf(String categoryName, String keyName) {
        return this.getSettings().getValueOf(categoryName, keyName);
    }

    public String getValueOf(String keyName) {
        return this.getSettings().getValueOf(keyName);
    }

    public String[] getCategoryNames() {
        return this.getSettings().getCategoryNames();
    }

    public String[] getKeyNamesOf(String categoryName) {
        return this.getSettings().getKeyNamesOf(categoryName);
    }

    public String[] getKeyNamesOfDefaultCategory() {
        return this.getSettings().getKeyNamesOfDefaultCategory();
    }

    public ReadOnlySettings getDefaults() {
        return this.getSettings().getDefaults();
    }

    public void setDefaults(ReadOnlySettings defaults) {
        this.getSettings().setDefaults(defaults);
    }

    public String getSettingsNameOf(String categoryName, String keyName) {
        return this.getSettings().getSettingsNameOf(categoryName, keyName);
    }

    public String getSettingsNameOf(String keyName) {
        return this.getSettings().getSettingsNameOf(keyName);
    }

    public boolean canBeTriggeredBy(Trigger trigger) {
        boolean canTrigger = this.currentFileTimestamp() > this.getFileTimestamp();
        return canTrigger;
    }

    public boolean triggeredBy(Trigger trigger) {
        try {
            if (this.loadSettings()) {
                this.notifyObservers();
            }
        }
        catch (ReloadableSettingsException reloadableSettingsException) {
            // empty catch block
        }
        return true;
    }

    public void stopReloading() {
        if (this.getFileCheckTrigger() != null) {
            this.getFileCheckTrigger().terminate();
            this.setFileCheckTrigger(null);
        }
    }

    public void startReloading(long checkInterval) {
        if (this.getFileCheckTrigger() == null) {
            this.startTrigger(checkInterval);
        }
    }

    protected boolean loadSettings() throws ReloadableSettingsException {
        Settings someSettings = null;
        String filename = this.getFile().getAbsolutePath();
        if (this.fileExists()) {
            someSettings = this.getReader().loadSettings();
            if (someSettings == null) {
                this.throwException(3, "Loading settings from file '" + filename + "' failed!");
            } else {
                this.setFileTimestamp(this.currentFileTimestamp());
                this.replaceSettings(someSettings);
                this.setChanged();
                return true;
            }
        }
        if (this.fileMustExist()) {
            this.throwException(3, "File '" + filename + "' not found!");
        }
        this.setFileTimestamp(UNKNOWN_FILE_TIMESTAMP);
        this.replaceSettings(new SettingsImpl(filename));
        return false;
    }

    protected void checkAndRememberFile(String filename, boolean mustExist) throws ReloadableSettingsException {
        File aFile = new File(filename);
        this.setFile(aFile);
        if (!aFile.exists() && mustExist) {
            this.throwException(2, "File '" + filename + "' not found!");
        }
    }

    protected void startTrigger(long intervalInSeconds) {
        String triggerName = "Settings://" + this.getFile().getName();
        Trigger trigger = Trigger.launch(triggerName, this, intervalInSeconds * 1000L);
        this.setFileCheckTrigger(trigger);
    }

    protected long currentFileTimestamp() {
        if (this.fileExists()) {
            return this.getFile().lastModified();
        }
        return UNKNOWN_FILE_TIMESTAMP;
    }

    protected void replaceSettings(ReadOnlySettings newSettings) {
        if (this.getSettings() != null) {
            ReadOnlySettings defaults = this.getSettings().getDefaults();
            newSettings.setDefaults(defaults);
        }
        this.setSettings(newSettings);
    }

    protected boolean fileExists() {
        return this.getFile().exists();
    }

    protected ReloadableSettingsException invalidParameter(String paramName) {
        return this.createException(1, "Invalid parameter '" + paramName + "'");
    }

    protected void throwException(int code, String msg) throws ReloadableSettingsException {
        throw this.createException(code, msg);
    }

    protected ReloadableSettingsException createException(int code, String msg) {
        return new ReloadableSettingsException(code, msg);
    }
}

