/*
 * Decompiled with CFR 0.152.
 */
package org.pf.settings.rw;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.pf.file.ClasspathElement;
import org.pf.file.FileLocator;
import org.pf.settings.Settings;
import org.pf.settings.SettingsFileReader;
import org.pf.settings.rw.AbstractSettingsReaderWriter;

public abstract class AbstractSettingsFileReaderWriter
extends AbstractSettingsReaderWriter
implements SettingsFileReader {
    protected static final String NEWLINE = System.getProperty("line.separator");
    private String fileName = null;
    private String encoding = null;
    private FileLocator fileLocator = null;

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String aValue) {
        this.fileName = aValue;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String newValue) {
        this.encoding = newValue;
    }

    protected FileLocator getFileLocator() {
        return this.fileLocator;
    }

    protected void setFileLocator(FileLocator newValue) {
        this.fileLocator = newValue;
    }

    public AbstractSettingsFileReaderWriter() {
    }

    public AbstractSettingsFileReaderWriter(String filename) {
        this();
        this.setFileName(filename);
    }

    public AbstractSettingsFileReaderWriter(FileLocator fileLocator) {
        this();
        this.setFileName(fileLocator.getOriginalFileName());
        this.setFileLocator(fileLocator);
    }

    public Settings loadSettings(Class settingsClass) {
        if (this.getFileLocator() != null) {
            return this.readSettings(this.getFileLocator(), settingsClass);
        }
        return this.readSettings(this.getFileName(), settingsClass);
    }

    public Settings loadSettingsFrom(ClasspathElement classpathElement) throws IOException {
        return this.loadSettingsFrom(classpathElement, null);
    }

    public Settings loadSettingsFrom(ClasspathElement classpathElement, Class settingsClass) throws IOException {
        InputStream stream = classpathElement.open(this.getFileName());
        return (Settings)this.readFromStream(stream, settingsClass);
    }

    protected abstract Object readFromStream(InputStream var1, Class var2) throws IOException;

    protected abstract Settings convertToSettings(Object var1, Class var2);

    protected Settings readSettings(String filename, Class settingsClass) {
        FileLocator locator = null;
        locator = FileLocator.create(filename);
        return this.readSettings(locator, settingsClass);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Settings readSettings(FileLocator locator, Class settingsClass) {
        Settings settings = null;
        InputStream stream = null;
        try {
            if (!locator.exists()) return settings;
            try {
                try {
                    stream = locator.getInputStream();
                    Object result = this.readFromStream(stream, settingsClass);
                    settings = this.convertToSettings(result, settingsClass);
                    settings.setName(locator.getOriginalFileName());
                }
                catch (IOException ex) {
                    settings = null;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                this.fileUtil().close(stream);
                throw throwable;
            }
            {
                Object var7_10 = null;
                this.fileUtil().close(stream);
                return settings;
            }
        }
        catch (Exception ex) {
            return null;
        }
    }

    protected Reader createReader(InputStream stream) {
        InputStreamReader reader;
        if (this.getEncoding() == null) {
            reader = new InputStreamReader(stream);
        } else {
            try {
                reader = new InputStreamReader(stream, this.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                reader = new InputStreamReader(stream);
            }
        }
        return reader;
    }

    protected Writer createWriter(OutputStream stream) {
        OutputStreamWriter writer;
        if (this.getEncoding() == null) {
            writer = new OutputStreamWriter(stream);
        } else {
            try {
                writer = new OutputStreamWriter(stream, this.getEncoding());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
                writer = new OutputStreamWriter(stream);
            }
        }
        return new BufferedWriter(writer);
    }
}

