/*
 * Decompiled with CFR 0.152.
 */
package org.pf.settings.rw;

import java.io.IOException;
import java.io.InputStream;
import org.pf.file.FileLocator;
import org.pf.file.LineProcessor;
import org.pf.settings.Settings;
import org.pf.settings.rw.AbstractSettingsFileReaderWriter;
import org.pf.text.StringExaminer;
import org.pf.util.NamedText;

public class HttpdConfReaderWriter
extends AbstractSettingsFileReaderWriter {
    static /* synthetic */ Class class$0;

    public HttpdConfReaderWriter() {
    }

    public HttpdConfReaderWriter(String filename) {
        super(filename);
    }

    public HttpdConfReaderWriter(FileLocator locator) {
        super(locator);
    }

    public boolean storeSettings(Settings settings) {
        return false;
    }

    protected Object readFromStream(InputStream stream, Class settingsClass) throws IOException {
        Settings settings = null;
        settings = this.newSettings(settingsClass);
        this.readLines(settings, stream);
        return settings;
    }

    protected void readLines(Settings settings, InputStream stream) throws IOException {
        final Settings theSettings = settings;
        LineProcessor processor = new LineProcessor(){
            String categoryName = null;

            public boolean processLine(String textLine, int lineNo) {
                String line = HttpdConfReaderWriter.this.stripComment(textLine);
                if ((line = line.trim()).length() > 0) {
                    if (line.startsWith(HttpdConfReaderWriter.this.getSectionNameStartIndicator())) {
                        this.categoryName = this.categoryName == null ? HttpdConfReaderWriter.this.getCategoryName(line) : null;
                    } else {
                        NamedText keyValue = HttpdConfReaderWriter.this.splitNameValue(line);
                        theSettings.setValueOf(this.categoryName, keyValue.name(), keyValue.text());
                    }
                }
                return true;
            }
        };
        this.fileUtil().processTextLines(stream, processor);
    }

    protected Settings convertToSettings(Object result, Class settingsClass) {
        return (Settings)result;
    }

    protected NamedText splitNameValue(String line) {
        NamedText keyValue = null;
        StringBuffer nameBuffer = new StringBuffer(20);
        StringExaminer scanner = new StringExaminer(line);
        char ch = scanner.nextChar();
        while (ch != '\uffff' && !Character.isWhitespace(ch)) {
            nameBuffer.append(ch);
            ch = scanner.nextChar();
        }
        keyValue = new NamedText(nameBuffer.toString(), "");
        if (ch != '\uffff') {
            keyValue.text(scanner.upToEnd().trim());
        }
        return keyValue;
    }

    protected String getCategoryName(String line) {
        return this.str().getDelimitedSubstring(line, this.getSectionNameStartIndicator(), this.getSectionNameEndIndicator());
    }

    protected String stripComment(String line) {
        return this.str().upTo(line, this.getCommentSeparator());
    }

    protected String getSectionNameStartIndicator() {
        return "<";
    }

    protected String getSectionNameEndIndicator() {
        return ">";
    }

    protected String getCommentSeparator() {
        return "#";
    }

    protected Class getDefaultSettingsClass() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.pf.settings.impl.MultiValueSettingsImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }
}

