/*
 * Decompiled with CFR 0.152.
 */
package org.pf.settings.rw;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import org.pf.file.FileLocator;
import org.pf.file.LineProcessor;
import org.pf.settings.Settings;
import org.pf.settings.rw.AbstractSettingsFileReaderWriter;
import org.pf.text.StringFilter;
import org.pf.text.StringPattern;

public class IniReaderWriter
extends AbstractSettingsFileReaderWriter {
    protected static final String DEFAULT_CATEGORY_NAME = "";
    private String commentSeparator = ";";
    private String keyValueSeparator = "=";
    private boolean newlineAfterSection = true;

    public String getCommentSeparator() {
        return this.commentSeparator;
    }

    public void setCommentSeparator(String newValue) {
        this.commentSeparator = newValue;
    }

    public String getKeyValueSeparator() {
        return this.keyValueSeparator;
    }

    public void setKeyValueSeparator(String newValue) {
        this.keyValueSeparator = newValue;
    }

    public boolean getNewlineAfterSection() {
        return this.newlineAfterSection;
    }

    public void setNewlineAfterSection(boolean newValue) {
        this.newlineAfterSection = newValue;
    }

    public IniReaderWriter(String filename) {
        this(filename, null);
    }

    public IniReaderWriter(String filename, String charsetName) {
        super(filename);
        this.setEncoding(charsetName);
    }

    public IniReaderWriter(FileLocator locator) {
        this(locator, null);
    }

    public IniReaderWriter(FileLocator locator, String charsetName) {
        super(locator);
        this.setEncoding(charsetName);
    }

    public boolean storeSettings(Settings settings) {
        if (this.getFileName() == null) {
            return false;
        }
        return this.writeSettings(this.getFileName(), settings);
    }

    protected Object readFromStream(InputStream stream, Class settingsClass) throws IOException {
        Settings settings = null;
        settings = this.newSettings(settingsClass);
        this.readLines(settings, stream);
        return settings;
    }

    protected Settings convertToSettings(Object result, Class settingsClass) {
        return (Settings)result;
    }

    protected void readLines(Settings settings, InputStream stream) throws IOException {
        Reader reader = this.createReader(stream);
        this.readLines(settings, reader);
    }

    protected void readLines(Settings settings, Reader reader) throws IOException {
        final Settings theSettings = settings;
        LineProcessor processor = new LineProcessor(){
            String categoryName = null;

            public boolean processLine(String textLine, int lineNo) {
                String line = IniReaderWriter.this.stripComment(textLine);
                if ((line = line.trim()).length() > 0) {
                    if (line.startsWith(IniReaderWriter.this.getSectionStartIndicator())) {
                        this.categoryName = IniReaderWriter.this.getCategoryName(line);
                    } else {
                        String[] keyValue = IniReaderWriter.this.str().splitNameValue(line, IniReaderWriter.this.getKeyValueSeparator());
                        theSettings.setValueOf(this.categoryName, keyValue[0], keyValue[1]);
                    }
                }
                return true;
            }
        };
        this.fileUtil().processTextLines(reader, processor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean writeSettings(String filename, Settings settings) {
        FileOutputStream stream;
        try {
            stream = new FileOutputStream(filename);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        try {
            try {
                this.writeSettings(stream, settings);
            }
            catch (IOException e) {
                Object var5_6 = null;
                this.fileUtil().close(stream);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fileUtil().close(stream);
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.fileUtil().close(stream);
        }
        return true;
    }

    protected void writeSettings(OutputStream stream, Settings settings) throws IOException {
        Writer writer = this.createWriter(stream);
        this.writeSettings(writer, settings);
        writer.flush();
    }

    protected void writeSettings(Writer writer, Settings settings) throws IOException {
        String[] categoryNames = settings.getCategoryNames();
        if (this.str().contains(categoryNames, DEFAULT_CATEGORY_NAME)) {
            categoryNames = this.str().copyWithout(categoryNames, (StringFilter)new StringPattern(DEFAULT_CATEGORY_NAME));
            this.writeSettingsCategory(writer, settings, DEFAULT_CATEGORY_NAME);
        }
        int i = 0;
        while (i < categoryNames.length) {
            this.writeSettingsCategory(writer, settings, categoryNames[i]);
            ++i;
        }
    }

    protected void writeSettingsCategory(Writer writer, Settings settings, String category) throws IOException {
        if (!this.str().isNullOrEmpty(category)) {
            writer.write(this.getSectionStartIndicator());
            writer.write(category);
            writer.write(this.getSectionEndIndicator());
            writer.write(AbstractSettingsFileReaderWriter.NEWLINE);
        }
        String[] keys = settings.getKeyNamesOf(category);
        int i = 0;
        while (i < keys.length) {
            writer.write(keys[i]);
            writer.write(61);
            writer.write(settings.getValueOf(category, keys[i]));
            writer.write(AbstractSettingsFileReaderWriter.NEWLINE);
            ++i;
        }
        if (this.getNewlineAfterSection()) {
            writer.write(AbstractSettingsFileReaderWriter.NEWLINE);
        }
    }

    protected String getCategoryName(String line) {
        return this.str().getDelimitedSubstring(line, this.getSectionStartIndicator(), this.getSectionEndIndicator());
    }

    protected String stripComment(String line) {
        return this.str().upTo(line, this.getCommentSeparator());
    }

    protected String getSectionStartIndicator() {
        return "[";
    }

    protected String getSectionEndIndicator() {
        return "]";
    }
}

