/*
 * Decompiled with CFR 0.152.
 */
package org.pf.settings.rw;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.pf.file.FileFinder;
import org.pf.file.FileLocator;
import org.pf.file.FileUtil;
import org.pf.settings.Settings;
import org.pf.settings.rw.AbstractSettingsFileReaderWriter;

public class ManifestReaderWriter
extends AbstractSettingsFileReaderWriter {
    public static Settings manifestToSettings(Manifest manifest, Class settingsClass) {
        ManifestReaderWriter inst = new ManifestReaderWriter();
        return inst.convertManifestToSettings(manifest, settingsClass);
    }

    public static Settings loadSettings(String filename, Class settingsClass) {
        ManifestReaderWriter inst = new ManifestReaderWriter();
        return inst.readSettings(filename, settingsClass);
    }

    public static Manifest readManifestFrom(String filename) {
        ManifestReaderWriter inst = new ManifestReaderWriter();
        URL url = FileFinder.locateFile(filename);
        if (url == null) {
            return null;
        }
        try {
            return inst.readManifestFrom(url.openStream());
        }
        catch (IOException e) {
            return null;
        }
    }

    public ManifestReaderWriter() {
    }

    public ManifestReaderWriter(String aFilename) {
        super(aFilename);
    }

    public ManifestReaderWriter(FileLocator locator) {
        super(locator);
    }

    public boolean storeSettings(Settings settings) {
        return false;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Manifest readManifestFrom(InputStream stream) {
        Manifest manifest = null;
        ManifestReaderWriter inst = new ManifestReaderWriter();
        try {
            try {
                manifest = (Manifest)inst.readFromStream(stream, null);
            }
            catch (IOException iOException) {}
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            FileUtil.current().close(stream);
            throw throwable;
        }
        {
            Object var5_7 = null;
            FileUtil.current().close(stream);
        }
        return manifest;
    }

    protected Object readFromStream(InputStream stream, Class settingsClass) throws IOException {
        return new Manifest(stream);
    }

    protected Settings convertToSettings(Object result, Class settingsClass) {
        return this.convertManifestToSettings((Manifest)result, settingsClass);
    }

    protected Settings convertManifestToSettings(Manifest manifest, Class settingsClass) {
        Map<String, Attributes> entries = null;
        Iterator<String> iterator = null;
        Settings settings = null;
        Attributes attributes = null;
        String categoryName = null;
        settings = this.newSettings(settingsClass);
        this.addAttributesToSettings(null, manifest.getMainAttributes(), settings);
        entries = manifest.getEntries();
        iterator = entries.keySet().iterator();
        while (iterator.hasNext()) {
            categoryName = iterator.next();
            attributes = entries.get(categoryName);
            this.addAttributesToSettings(categoryName, attributes, settings);
        }
        return settings;
    }

    protected void addAttributesToSettings(String categoryName, Attributes attributes, Settings settings) {
        Iterator<Object> iterator = null;
        Attributes.Name key = null;
        String value = null;
        iterator = attributes.keySet().iterator();
        while (iterator.hasNext()) {
            key = (Attributes.Name)iterator.next();
            value = attributes.getValue(key);
            settings.setValueOf(categoryName, key.toString(), value);
        }
    }
}

