/*
 * Decompiled with CFR 0.152.
 */
package org.pf.settings.rw;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.Enumeration;
import java.util.Properties;
import org.pf.file.FileLocator;
import org.pf.file.PropertiesFileContent;
import org.pf.file.PropertyFileLoader;
import org.pf.settings.Settings;
import org.pf.settings.rw.AbstractSettingsFileReaderWriter;

public class PropertiesReaderWriter
extends AbstractSettingsFileReaderWriter {
    private boolean backslashIsEscapeChar = true;

    public boolean getBackslashIsEscapeChar() {
        return this.backslashIsEscapeChar;
    }

    public void setBackslashIsEscapeChar(boolean newValue) {
        this.backslashIsEscapeChar = newValue;
    }

    public static Settings propertiesToSettings(Properties properties, Class settingsClass) {
        PropertiesReaderWriter inst = new PropertiesReaderWriter();
        return inst.convertPropertiesToSettings(properties, settingsClass);
    }

    public static Settings loadSettings(String filename, Class settingsClass) {
        PropertiesReaderWriter inst = new PropertiesReaderWriter();
        return inst.readSettings(filename, settingsClass);
    }

    public static Settings loadSettings(FileLocator locator, Class settingsClass) {
        PropertiesReaderWriter inst = new PropertiesReaderWriter();
        return inst.readSettings(locator, settingsClass);
    }

    public PropertiesReaderWriter() {
    }

    public PropertiesReaderWriter(String filename) {
        this(filename, null);
    }

    public PropertiesReaderWriter(String filename, String charsetName) {
        super(filename);
        this.setEncoding(charsetName);
    }

    public PropertiesReaderWriter(FileLocator locator) {
        this(locator, null);
    }

    public PropertiesReaderWriter(FileLocator locator, String charsetName) {
        super(locator);
        this.setEncoding(charsetName);
    }

    public boolean storeSettings(Settings settings) {
        if (this.getFileName() == null) {
            return false;
        }
        return this.storeSettings(this.getFileName(), settings);
    }

    protected Object readFromStream(InputStream stream, Class settingsClass) throws IOException {
        if (this.mustUseReader()) {
            Reader reader = this.createReader(stream);
            return this.readFromReader(reader);
        }
        return PropertyFileLoader.loadProperties(stream);
    }

    protected PropertiesFileContent readFromReader(Reader reader) throws IOException {
        return PropertyFileLoader.loadFullPropertiesFile(reader);
    }

    protected boolean mustUseReader() {
        return !this.getBackslashIsEscapeChar() || this.getEncoding() != null;
    }

    protected Settings convertToSettings(Object result, Class settingsClass) {
        if (!(result instanceof Properties)) {
            return null;
        }
        return this.convertPropertiesToSettings((Properties)result, settingsClass);
    }

    protected Settings convertPropertiesToSettings(Properties properties, Class settingsClass) {
        Enumeration<?> propNames = null;
        String name = null;
        Settings settings = null;
        settings = this.newSettings(settingsClass);
        propNames = properties.propertyNames();
        while (propNames.hasMoreElements()) {
            name = (String)propNames.nextElement();
            settings.setValueOf(name, properties.getProperty(name));
        }
        return settings;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean storeSettings(String filename, Settings settings) {
        Writer writer;
        try {
            writer = this.createWriter(new FileOutputStream(filename));
        }
        catch (IOException e) {
            return false;
        }
        try {
            try {
                this.writeSettings(writer, settings);
            }
            catch (IOException e) {
                Object var5_6 = null;
                this.fileUtil().close(writer);
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            this.fileUtil().close(writer);
            throw throwable;
        }
        {
            Object var5_8 = null;
            this.fileUtil().close(writer);
        }
        return true;
    }

    protected void writeSettings(Writer writer, Settings settings) throws IOException {
        String[] keys = settings.getKeyNamesOfDefaultCategory();
        int i = 0;
        while (i < keys.length) {
            writer.write(keys[i]);
            writer.write("=");
            writer.write(settings.getValueOf(keys[i]));
            writer.write(AbstractSettingsFileReaderWriter.NEWLINE);
            ++i;
        }
        writer.flush();
    }
}

