/*
 * Decompiled with CFR 0.152.
 */
package org.pf.six;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.pf.text.StringUtil;

public class Element {
    protected static final String NAMESPACE_SEPARATOR = ":";
    protected static final String NAMESPACE_PREFIX = "xmlns:";
    private static final int NOT_FOUND_INDEX = -1;
    private String name = null;
    private String text = null;
    private Map elementAttributes = new HashMap();
    private Element[] childElements = null;
    private Map namespaces = null;

    public Map getAttributes() {
        return this.elementAttributes;
    }

    protected void setAttributes(Map newValue) {
        this.elementAttributes = newValue;
    }

    protected Element[] getChildElements() {
        return this.childElements;
    }

    protected void setChildElements(Element[] newValue) {
        this.childElements = newValue;
    }

    protected Map getNamespaces() {
        return this.namespaces;
    }

    protected void setNamespaces(Map newValue) {
        this.namespaces = newValue;
    }

    public Element() {
    }

    public Element(String tagName) {
        this();
        this.setName(tagName);
    }

    public Element(String tagName, String text) {
        this();
        this.setName(tagName);
        this.setText(text);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String newName) {
        this.name = newName;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
    }

    public String getAttribute(String attrName) {
        return (String)this.getAttributes().get(attrName);
    }

    public void setAttribute(String attrName, String value) {
        this.getAttributes().put(attrName, value);
    }

    public void removeAttribute(String attrName) {
        this.getAttributes().remove(attrName);
    }

    public String[] getAttributeNames() {
        String[] names = StringUtil.EMPTY_STRING_ARRAY;
        Iterator nameIterator = null;
        int index = 0;
        if (this.hasAttributes()) {
            names = new String[this.getAttributes().size()];
            nameIterator = this.getAttributes().keySet().iterator();
            while (nameIterator.hasNext()) {
                names[index] = (String)nameIterator.next();
                ++index;
            }
        }
        return names;
    }

    public int getChildrenCount() {
        if (this.hasChildren()) {
            return this.getChildren().length;
        }
        return 0;
    }

    public Element[] getChildren() {
        return this.getChildElements();
    }

    public boolean hasChildren() {
        return this.getChildElements() != null;
    }

    public boolean removeChild(Element childElement) {
        int index = this.indexOfChild(childElement);
        if (index == -1) {
            return false;
        }
        int newLen = this.getChildrenCount() - 1;
        if (newLen > 0) {
            Element[] newArray = new Element[newLen];
            System.arraycopy(this.getChildren(), 0, newArray, 0, index);
            System.arraycopy(this.getChildren(), index + 1, newArray, index, newLen - index);
            this.setChildElements(newArray);
        } else {
            this.setChildElements(null);
        }
        return true;
    }

    public void removeAllChildren() {
        this.setChildElements(null);
    }

    public void removeText() {
        this.setText(null);
    }

    public boolean hasText() {
        return this.getText() != null;
    }

    public boolean hasAttributes() {
        return this.getAttributes() != null && this.getAttributes().size() > 0;
    }

    public boolean hasAttribute(String attrName) {
        return this.getAttribute(attrName) != null;
    }

    public String toString() {
        return "<" + this.getName() + ">";
    }

    public void addChild(Element childElement) {
        Element[] newArray;
        if (childElement == null) {
            return;
        }
        if (this.hasChildren()) {
            newArray = new Element[this.getChildrenCount() + 1];
            System.arraycopy(this.getChildren(), 0, newArray, 0, this.getChildrenCount());
        } else {
            newArray = new Element[1];
        }
        this.setChildElements(newArray);
        this.getChildren()[this.getChildrenCount() - 1] = childElement;
    }

    public boolean insertChildAfter(Element oldChild, Element newChild) {
        if (oldChild == null || newChild == null) {
            return false;
        }
        int index = this.indexOfChild(oldChild);
        if (index == -1) {
            return false;
        }
        this.insertAfter(index, newChild);
        return true;
    }

    public boolean insertChildBefore(Element oldChild, Element newChild) {
        if (oldChild == null || newChild == null) {
            return false;
        }
        int index = this.indexOfChild(oldChild);
        if (index == -1) {
            return false;
        }
        this.insertBefore(index, newChild);
        return true;
    }

    public boolean replaceChild(Element oldChild, Element newChild) {
        if (oldChild == null || newChild == null) {
            return false;
        }
        int index = this.indexOfChild(oldChild);
        if (index == -1) {
            return false;
        }
        this.childElements[index] = newChild;
        return true;
    }

    public Element[] find(String tagName) {
        return this.find(tagName, null);
    }

    public Element[] find(String tagName, Map attributes) {
        List result = this.collect(tagName, attributes, true);
        if (this.matches(this, tagName, attributes)) {
            result.add(this);
        }
        return this.toArray(result);
    }

    public Element[] findSubElements(String tagName) {
        return this.collectElements(tagName, null, true);
    }

    public Element[] findSubElements(String tagName, Map attributes) {
        return this.collectElements(tagName, attributes, true);
    }

    public Element[] findChildren(String tagName) {
        return this.collectElements(tagName, null, false);
    }

    public Element[] findChildren(String tagName, Map attributes) {
        return this.collectElements(tagName, attributes, false);
    }

    public Element shallowCopy() {
        Element copy = new Element(this.getName());
        if (this.hasAttributes()) {
            String[] names = this.getAttributeNames();
            int i = 0;
            while (i < names.length) {
                copy.setAttribute(names[i], this.getAttribute(names[i]));
                ++i;
            }
        }
        if (this.hasText()) {
            copy.setText(this.getText());
        }
        return copy;
    }

    public Element deepCopy() {
        Element copy = this.shallowCopy();
        if (this.hasChildren()) {
            Element[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                copy.addChild(children[i].deepCopy());
                ++i;
            }
        }
        return copy;
    }

    public Element copy() {
        return this.deepCopy();
    }

    public Map getNamespaceDeclarations() {
        if (this.getNamespaces() == null) {
            this.setNamespaces(this.detectNamespaceDeclarations());
        }
        return this.getNamespaces();
    }

    protected List collect(String tagName, Map attributes, boolean all) {
        if (!this.hasChildren()) {
            return new ArrayList();
        }
        ArrayList<Element> result = new ArrayList<Element>(this.getChildrenCount());
        Element[] subElements = this.getChildren();
        int i = 0;
        while (i < subElements.length) {
            if (this.matches(subElements[i], tagName, attributes)) {
                result.add(subElements[i]);
            }
            if (all) {
                result.addAll(subElements[i].collect(tagName, attributes, true));
            }
            ++i;
        }
        return result;
    }

    protected Element[] collectElements(String tagName, Map attributes, boolean all) {
        return this.toArray(this.collect(tagName, attributes, all));
    }

    protected Element[] toArray(List elementList) {
        return elementList.toArray(new Element[0]);
    }

    protected boolean matches(Element element, String tagName, Map attributes) {
        if (tagName.equals(element.getName())) {
            if (attributes != null) {
                Iterator iterator = attributes.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = iterator.next();
                    String key = (String)entry.getKey();
                    String value = element.getAttribute(key);
                    if (value == null) {
                        return false;
                    }
                    String expectedValue = (String)entry.getValue();
                    if (value.equals(expectedValue)) continue;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    protected Map detectNamespaceDeclarations() {
        HashMap<String, String> foundNamespaces = new HashMap<String, String>();
        String[] attrNames = this.getAttributeNames();
        int i = 0;
        while (i < attrNames.length) {
            if (attrNames[i].startsWith(NAMESPACE_PREFIX)) {
                String nsId = this.str().suffix(attrNames[i], NAMESPACE_SEPARATOR);
                String nsUri = this.getAttribute(attrNames[i]);
                foundNamespaces.put(nsId, nsUri);
            }
            ++i;
        }
        return foundNamespaces;
    }

    protected int indexOfChild(Element child) {
        if (this.hasChildren() && child != null) {
            int i = 0;
            while (i < this.childElements.length) {
                if (this.childElements[i] == child) {
                    return i;
                }
                ++i;
            }
        }
        return -1;
    }

    protected void insertAfter(int index, Element newChild) {
        if (newChild == null) {
            return;
        }
        int newLen = this.getChildrenCount() + 1;
        Element[] newArray = new Element[newLen];
        System.arraycopy(this.getChildren(), 0, newArray, 0, index + 1);
        System.arraycopy(this.getChildren(), index + 1, newArray, index + 2, newLen - index - 2);
        newArray[index + 1] = newChild;
        this.setChildElements(newArray);
    }

    protected void insertBefore(int index, Element newChild) {
        if (newChild == null) {
            return;
        }
        int newLen = this.getChildrenCount() + 1;
        Element[] newArray = new Element[newLen];
        if (index == 0) {
            System.arraycopy(this.getChildren(), 0, newArray, 1, this.getChildrenCount());
            newArray[0] = newChild;
            this.setChildElements(newArray);
        } else {
            this.insertAfter(index - 1, newChild);
        }
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

