/*
 * Decompiled with CFR 0.152.
 */
package org.pf.six;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.pf.six.EmptyEntityResolver;
import org.pf.text.StringUtil;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class FileEntityResolver
extends EmptyEntityResolver {
    protected static final String DTD_EXTENSION = ".DTD";
    private boolean isValidating = true;

    protected boolean isValidating() {
        return this.isValidating;
    }

    protected void isValidating(boolean newValue) {
        this.isValidating = newValue;
    }

    public FileEntityResolver() {
        this(true);
    }

    public FileEntityResolver(boolean validating) {
        this.isValidating(validating);
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        if (systemId == null) {
            return null;
        }
        if (!this.isValidating() && this.isDTD(systemId)) {
            return super.resolveEntity(publicId, systemId);
        }
        String filename = this.extractFilename(systemId);
        if (filename == null) {
            return null;
        }
        File file = new File(filename);
        FileInputStream stream = new FileInputStream(file);
        InputSource source = new InputSource(stream);
        return source;
    }

    protected boolean isDTD(String filename) {
        String fName = filename.toUpperCase();
        return fName.endsWith(DTD_EXTENSION);
    }

    protected String extractFilename(String id) {
        String protocol = this.str().prefix(id, "//");
        if (protocol == null) {
            return id;
        }
        if ("file:".equals(protocol)) {
            return this.str().suffix(id, "file://");
        }
        return null;
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

