/*
 * Decompiled with CFR 0.152.
 */
package org.pf.six;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.pf.logging.Logger;
import org.pf.pax.DOMTreeXMLReader;
import org.pf.six.Element;
import org.pf.six.LoggerProvider;
import org.pf.six.StringTagInterpreterController;
import org.pf.text.StringUtil;
import org.pf.util.StackedMap;
import org.w3c.dom.Document;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ModelConverter {
    private Document document = null;

    protected Document getDocument() {
        return this.document;
    }

    protected void setDocument(Document newValue) {
        this.document = newValue;
    }

    public Document toDOM(Element rootElement) {
        this.newDocument();
        if (rootElement != null) {
            org.w3c.dom.Element rootDOMElement = this.convertElement(rootElement, new NamespaceStack());
            this.getDocument().appendChild(rootDOMElement);
        }
        return this.getDocument();
    }

    public Element toSIXElement(Document doc) {
        StringTagInterpreterController controller = null;
        DOMTreeXMLReader xmlReader = null;
        xmlReader = new DOMTreeXMLReader();
        try {
            controller = new StringTagInterpreterController(xmlReader);
            xmlReader.parse(doc);
        }
        catch (SAXException e) {
            this.logger().logException(e);
            return null;
        }
        return controller.getElement();
    }

    protected org.w3c.dom.Element convertElement(Element element, NamespaceStack namespaces) {
        namespaces.push(element.getNamespaceDeclarations());
        org.w3c.dom.Element domElement = this.createDOMElement(element.getName(), namespaces);
        this.convertAttributes(element, domElement, namespaces);
        this.convertText(element, domElement);
        this.convertChildren(element, domElement, namespaces);
        namespaces.pop();
        return domElement;
    }

    protected void convertText(Element element, org.w3c.dom.Element domElement) {
        if (element.hasText()) {
            domElement.appendChild(this.createDOMText(element.getText()));
        }
    }

    protected void convertAttributes(Element element, org.w3c.dom.Element domElement, NamespaceStack namespaces) {
        if (element.hasAttributes()) {
            String[] attrNames = element.getAttributeNames();
            int i = 0;
            while (i < attrNames.length) {
                String value = element.getAttribute(attrNames[i]);
                String nsURI = namespaces.namespaceURIFor(attrNames[i]);
                if (nsURI == null) {
                    domElement.setAttribute(attrNames[i], value);
                } else {
                    domElement.setAttributeNS(nsURI, attrNames[i], value);
                }
                ++i;
            }
        }
    }

    protected void convertChildren(Element element, org.w3c.dom.Element domElement, NamespaceStack namespaces) {
        if (element.hasChildren()) {
            Element[] children = element.getChildren();
            int i = 0;
            while (i < children.length) {
                domElement.appendChild(this.convertElement(children[i], namespaces));
                ++i;
            }
        }
    }

    protected void newDocument() {
        Document doc = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.newDocument();
        }
        catch (ParserConfigurationException e) {
            this.logger().logException(e);
        }
        this.setDocument(doc);
    }

    protected org.w3c.dom.Element createDOMElement(String name, NamespaceStack namespaces) {
        String nsURI = namespaces.namespaceURIFor(name);
        if (nsURI == null) {
            return this.getDocument().createElement(name);
        }
        return this.getDocument().createElementNS(nsURI, name);
    }

    protected Text createDOMText(String text) {
        return this.getDocument().createTextNode(text);
    }

    protected Logger logger() {
        return LoggerProvider.getLogger();
    }

    protected static class NamespaceStack
    extends StackedMap {
        public String namespaceURIFor(String name) {
            String nsId = StringUtil.current().prefix(name, ":");
            if (nsId != null) {
                return (String)this.get(nsId);
            }
            return null;
        }
    }
}

