/*
 * Decompiled with CFR 0.152.
 */
package org.pf.six;

import org.pf.logging.Logger;
import org.pf.pax.BaseXMLTagInterpreterController;
import org.pf.pax.XMLTagInterpreterFactory;
import org.pf.six.Element;
import org.pf.six.LoggerProvider;
import org.pf.six.StringTagInterpreterFactory;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;

class StringTagInterpreterController
extends BaseXMLTagInterpreterController {
    private Element element = null;

    public Element getElement() {
        return this.element;
    }

    protected void setElement(Element newValue) {
        this.element = newValue;
    }

    public StringTagInterpreterController(XMLReader xmlReader) {
        super(xmlReader);
        xmlReader.setErrorHandler(this);
    }

    public void error(SAXParseException exception) throws SAXException {
        this.reportError(exception);
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.reportError(exception);
    }

    public void warning(SAXParseException exception) throws SAXException {
        this.reportError(exception);
    }

    protected void handleFinalResult(Object result) {
        this.setElement((Element)result);
    }

    protected XMLTagInterpreterFactory createTagInterpreterFactory() {
        return new StringTagInterpreterFactory();
    }

    protected void reportError(SAXParseException ex) throws SAXException {
        if (LoggerProvider.isLoggingSupressed()) {
            throw ex;
        }
        String msg = "XML parser: Error in line: " + ex.getLineNumber() + " column: " + ex.getColumnNumber() + " ( " + ex.getMessage() + " )";
        if (ex.getSystemId() != null) {
            msg = String.valueOf(msg) + " --- " + ex.getSystemId();
        }
        StringTagInterpreterController.logger().logError(msg);
    }

    protected static Logger logger() {
        return LoggerProvider.getLogger();
    }
}

