/*
 * Decompiled with CFR 0.152.
 */
package org.pf.six;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import org.pf.logging.Logger;
import org.pf.pax.SAXConstants;
import org.pf.six.Element;
import org.pf.six.FileEntityResolver;
import org.pf.six.LoggerProvider;
import org.pf.six.StringTagInterpreterController;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlStreamReader
implements SAXConstants {
    private XmlStreamReader() {
    }

    public static Element readFrom(String xmlFileName) {
        return XmlStreamReader.readFrom(xmlFileName, false);
    }

    public static Element readFrom(String xmlFileName, boolean validating) {
        return XmlStreamReader.readFrom(new File(xmlFileName), validating);
    }

    public static Element readFrom(File file, boolean validating) {
        Element result = null;
        FileInputStream stream = null;
        String fName = null;
        try {
            fName = file.getAbsolutePath();
            stream = new FileInputStream(fName);
            result = XmlStreamReader.readFrom(stream, fName, validating);
        }
        catch (IOException ex1) {
            XmlStreamReader.logger().logException(ex1);
        }
        return result;
    }

    public static Element readFrom(InputStream xmlStream, String uri, boolean validating) {
        Element result = null;
        try {
            result = XmlStreamReader.loadFrom(xmlStream, uri, validating);
        }
        catch (Exception ex1) {
            if (uri != null) {
                XmlStreamReader.logger().logError("Error parsing: " + uri);
            }
            XmlStreamReader.logger().logException(ex1);
        }
        return result;
    }

    public static Document readDOM(String xmlFileName) {
        return XmlStreamReader.readDOM(xmlFileName, false);
    }

    public static Document readDOM(String xmlFileName, boolean validating) {
        return XmlStreamReader.readDOM(new File(xmlFileName), validating);
    }

    public static Document readDOM(File file, boolean validating) {
        Document result = null;
        FileInputStream stream = null;
        String fName = null;
        try {
            fName = file.getAbsolutePath();
            stream = new FileInputStream(fName);
            result = XmlStreamReader.readDOM(stream, fName, validating);
        }
        catch (IOException ex1) {
            XmlStreamReader.logger().logException(ex1);
        }
        return result;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Document readDOM(InputStream xmlStream, String uri, boolean validating) {
        Document result = null;
        try {
            try {
                result = XmlStreamReader.loadDOM(xmlStream, uri, validating);
            }
            catch (Exception ex1) {
                if (uri != null) {
                    XmlStreamReader.logger().logError("Error parsing: " + uri);
                }
                XmlStreamReader.logger().logException(ex1);
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            try {
                xmlStream.close();
                throw throwable;
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        try {}
        catch (Exception exception) {
            return result;
        }
        xmlStream.close();
        return result;
    }

    public static Element readFrom(InputStream xmlStream, boolean validating) {
        return XmlStreamReader.readFrom(xmlStream, null, validating);
    }

    public static Element readFrom(InputStream xmlStream) {
        return XmlStreamReader.readFrom(xmlStream, null, false);
    }

    public static Element loadFrom(InputStream xmlStream) throws IOException, SAXException, ParserConfigurationException {
        return XmlStreamReader.loadFrom(xmlStream, false);
    }

    public static Element loadFrom(InputStream xmlStream, boolean validating) throws IOException, SAXException, ParserConfigurationException {
        return XmlStreamReader.loadFrom(xmlStream, null, validating);
    }

    public static Element loadFrom(InputStream xmlStream, String uri, boolean validating) throws IOException, SAXException, ParserConfigurationException {
        InputSource source = null;
        source = new InputSource(xmlStream);
        if (uri != null) {
            uri = uri.replace('\\', '/');
            source.setSystemId(uri);
        }
        return XmlStreamReader.loadFrom(source, validating);
    }

    public static Element loadFrom(InputSource source, boolean validating) throws IOException, SAXException, ParserConfigurationException {
        StringTagInterpreterController controller = null;
        XMLReader xmlReader = null;
        xmlReader = SAXParserFactory.newInstance().newSAXParser().getXMLReader();
        xmlReader.setFeature("http://xml.org/sax/features/validation", validating);
        xmlReader.setEntityResolver(new FileEntityResolver(validating));
        controller = new StringTagInterpreterController(xmlReader);
        xmlReader.parse(source);
        return controller.getElement();
    }

    public static Document loadDOM(InputStream xmlStream, String uri, boolean validating) throws IOException, SAXException, ParserConfigurationException {
        InputSource source = null;
        source = new InputSource(xmlStream);
        if (uri != null) {
            if ((uri = uri.replace('\\', '/')).indexOf("://") < 0) {
                uri = "file://" + uri;
            }
            source.setSystemId(uri);
        }
        return XmlStreamReader.loadDOM(source, validating);
    }

    public static Document loadDOM(InputSource source, boolean validating) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder docBuilder = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(validating);
        docBuilder = factory.newDocumentBuilder();
        docBuilder.setEntityResolver(new FileEntityResolver(validating));
        Document document = docBuilder.parse(source);
        return document;
    }

    protected static Logger logger() {
        return LoggerProvider.getLogger();
    }
}

