/*
 * Decompiled with CFR 0.152.
 */
package org.pf.six;

import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.pf.logging.Logger;
import org.pf.pax.DOMTreeXMLReader;
import org.pf.pax.XMLWriteController;
import org.pf.six.Element;
import org.pf.six.LoggerProvider;
import org.pf.six.ModelConverter;
import org.pf.text.StringUtil;
import org.pf.util.NamedTextList;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;

public class XmlStreamWriter {
    private static final String NEWLINE = System.getProperty("line.separator");
    protected static final XmlStreamWriter defaultInstance = XmlStreamWriter.n();
    private boolean usingDoubleQuotes = true;
    private boolean withNamespacePrefix = false;

    protected boolean getUsingDoubleQuotes() {
        return this.usingDoubleQuotes;
    }

    protected void setUsingDoubleQuotes(boolean newValue) {
        this.usingDoubleQuotes = newValue;
    }

    public boolean withNamespacePrefix() {
        return this.withNamespacePrefix;
    }

    public void withNamespacePrefix(boolean newValue) {
        this.withNamespacePrefix = newValue;
    }

    public static void writeWellFormedXML(Element element, Writer writer, String encoding) {
        defaultInstance.appendWellFormedXML(element, writer, encoding, null);
    }

    public static void writeWellFormedXML(Element element, Writer writer, String encoding, String dtdURL) {
        defaultInstance.appendWellFormedXML(element, writer, encoding, dtdURL);
    }

    public static void writeDocumentStart(Writer writer, String encoding) {
        defaultInstance.appendDocumentStart(writer, encoding, false);
    }

    public static void writeDocumentStart(Writer writer, String encoding, boolean isStandalone) {
        defaultInstance.appendDocumentStart(writer, encoding, isStandalone);
    }

    public static void writeDocumentType(Writer writer, String rootTagName, String dtdURL) {
        defaultInstance.appendDocumentType(writer, rootTagName, dtdURL);
    }

    public static void writeSIXElement(Element element, Writer writer) {
        defaultInstance.appendSIXElement(element, writer);
    }

    public static void writeDOM(Document document, Writer writer) {
        defaultInstance.appendDOM(document, writer);
    }

    public static XmlStreamWriter n() {
        return new XmlStreamWriter();
    }

    protected static Logger logger() {
        return LoggerProvider.getLogger();
    }

    public void useSingleQuotes() {
        this.setUsingDoubleQuotes(false);
    }

    public void useDoubleQuotes() {
        this.setUsingDoubleQuotes(true);
    }

    public void appendWellFormedXML(Element element, Writer writer, String encoding) {
        this.appendWellFormedXML(element, writer, encoding, null);
    }

    public void appendWellFormedXML(Element element, Writer writer, String encoding, String dtdURL) {
        this.appendDocumentStart(writer, encoding, dtdURL == null);
        if (dtdURL != null) {
            this.appendDocumentType(writer, element.getName(), dtdURL);
        }
        this.appendSIXElement(element, writer);
    }

    public void appendDocumentStart(Writer writer, String encoding) {
        this.appendDocumentStart(writer, encoding, false);
    }

    public void appendDocumentStart(Writer writer, String encoding, boolean isStandalone) {
        try {
            writer.write("<?xml version=");
            this.writeQuoted(writer, "1.0");
            if (encoding != null) {
                writer.write(" encoding=");
                this.writeQuoted(writer, encoding);
            }
            if (isStandalone) {
                writer.write(" standalone=");
                this.writeQuoted(writer, "yes");
            }
            writer.write(" ?>");
            writer.write(NEWLINE);
        }
        catch (IOException e) {
            XmlStreamWriter.logger().logException(e);
        }
    }

    public void appendXslStylesheetPI(Writer writer, String xslFilename) {
        if (writer == null || xslFilename == null) {
            XmlStreamWriter.logger().logError("null argument passed to " + this.getClass().getName() + ". appendXslStylesheetPI(Writer,String)");
            return;
        }
        NamedTextList attrs = new NamedTextList();
        attrs.add("type", "text/xsl");
        attrs.add("href", xslFilename);
        this.appendStylesheetPI(writer, attrs);
    }

    public void appendStylesheetPI(Writer writer, String attributes) {
        if (writer == null || attributes == null) {
            XmlStreamWriter.logger().logError("null argument passed to " + this.getClass().getName() + ". appendStylesheetPI(Writer,String)");
            return;
        }
        Map attrMap = this.str().asMap(attributes, ",");
        this.appendStylesheetPI(writer, attrMap);
    }

    public void appendStylesheetPI(Writer writer, Map attributes) {
        if (writer == null || attributes == null) {
            XmlStreamWriter.logger().logError("null argument passed to " + this.getClass().getName() + ". appendStylesheetPI(Writer,Map)");
            return;
        }
        NamedTextList namedTextList = new NamedTextList(attributes);
        this.appendStylesheetPI(writer, namedTextList);
    }

    public void appendStylesheetPI(Writer writer, NamedTextList attributes) {
        if (writer == null || attributes == null) {
            XmlStreamWriter.logger().logError("null argument passed to " + this.getClass().getName() + ". appendStylesheetPI(Writer,NamedTextList)");
            return;
        }
        try {
            writer.write("<?xml-stylesheet ");
            int i = 0;
            while (i < attributes.size()) {
                if (i > 0) {
                    writer.write(" ");
                }
                writer.write(attributes.nameAt(i));
                writer.write("=");
                this.writeQuoted(writer, attributes.textAt(i));
                ++i;
            }
            writer.write(" ?>");
            writer.write(NEWLINE);
        }
        catch (IOException e) {
            XmlStreamWriter.logger().logException(e);
        }
    }

    public void appendDocumentType(Writer writer, String rootTagName, String dtdURL) {
        try {
            writer.write("<!DOCTYPE ");
            writer.write(rootTagName);
            writer.write(" SYSTEM ");
            this.writeQuoted(writer, dtdURL);
            writer.write(" >");
            writer.write(NEWLINE);
        }
        catch (IOException e) {
            XmlStreamWriter.logger().logException(e);
        }
    }

    public void appendSIXElement(Element element, Writer writer) {
        ModelConverter converter = new ModelConverter();
        Document document = converter.toDOM(element);
        this.appendDOM(document, writer);
    }

    public void appendDOM(Document document, Writer writer) {
        DOMTreeXMLReader xmlReader = this.newXMLReader();
        XMLWriteController controller = new XMLWriteController(xmlReader, writer);
        if (this.getUsingDoubleQuotes()) {
            controller.useDoubleQuotes();
        } else {
            controller.useSingleQuotes();
        }
        try {
            xmlReader.parse(document);
        }
        catch (SAXException ex) {
            XmlStreamWriter.logger().logException(ex);
        }
    }

    protected void writeQuoted(Writer writer, String text) throws IOException {
        writer.write(this.getQuoteChar());
        writer.write(text);
        writer.write(this.getQuoteChar());
    }

    protected char getQuoteChar() {
        return this.getUsingDoubleQuotes() ? (char)'\"' : '\'';
    }

    protected DOMTreeXMLReader newXMLReader() {
        DOMTreeXMLReader xmlReader = new DOMTreeXMLReader();
        if (this.withNamespacePrefix()) {
            try {
                xmlReader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            }
            catch (SAXNotRecognizedException e) {
                XmlStreamWriter.logger().logException(e);
            }
            catch (SAXNotSupportedException e) {
                XmlStreamWriter.logger().logException(e);
            }
        }
        return xmlReader;
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

