/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import org.pf.text.MatchRuleParseException;
import org.pf.text.StringScanner;
import org.pf.text.StringUtil;

public abstract class BaseMatchRuleParser {
    private StringScanner scanner = null;

    protected StringScanner scanner() {
        return this.scanner;
    }

    protected void scanner(StringScanner newValue) {
        this.scanner = newValue;
    }

    public BaseMatchRuleParser() {
    }

    public BaseMatchRuleParser(String rule) {
        this();
        this.scanner(new StringScanner(rule));
    }

    protected boolean atEnd(char ch) {
        return ch == '\uffff';
    }

    protected void checkUnexpectedEnd(char ch) throws MatchRuleParseException {
        if (this.atEnd(ch)) {
            this.throwException("Unexpected end of string reached");
        }
    }

    protected void checkExpectedEnd(char ch) throws MatchRuleParseException {
        if (!this.atEnd(ch)) {
            this.throwException("Nothing more expected at position " + this.scanner().getPosition() + ", but found '" + ch + "'");
        }
    }

    protected void throwException(String msg) throws MatchRuleParseException {
        MatchRuleParseException exception = new MatchRuleParseException(msg);
        exception.setPosition(this.scanner().getPosition());
        exception.setParseString(this.scanner().toString());
        throw exception;
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

