/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.util.ArrayList;
import java.util.Map;
import org.pf.text.BaseMatchRuleParser;
import org.pf.text.MatchAttribute;
import org.pf.text.MatchElement;
import org.pf.text.MatchGroup;
import org.pf.text.MatchRule;
import org.pf.text.MatchRuleChars;
import org.pf.text.MatchRuleException;
import org.pf.text.MatchRuleParseException;
import org.pf.text.StringPattern;
import org.pf.text.StringScanner;

public class DefaultMatchRuleParser
extends BaseMatchRuleParser {
    private MatchRuleChars ruleChars = new MatchRuleChars();
    private boolean ignoreCaseInNames = false;
    private boolean ignoreCaseInValues = false;
    private boolean multiCharWildcardMatchesEmptyString = false;

    protected MatchRuleChars getRuleChars() {
        return this.ruleChars;
    }

    protected void setRuleChars(MatchRuleChars newValue) {
        this.ruleChars = newValue;
    }

    public boolean getIgnoreCaseInNames() {
        return this.ignoreCaseInNames;
    }

    public void setIgnoreCaseInNames(boolean newValue) {
        this.ignoreCaseInNames = newValue;
    }

    public boolean getIgnoreCaseInValues() {
        return this.ignoreCaseInValues;
    }

    public void setIgnoreCaseInValues(boolean newValue) {
        this.ignoreCaseInValues = newValue;
    }

    public boolean getMultiCharWildcardMatchesEmptyString() {
        return this.multiCharWildcardMatchesEmptyString;
    }

    public void setMultiCharWildcardMatchesEmptyString(boolean newValue) {
        this.multiCharWildcardMatchesEmptyString = newValue;
    }

    public static MatchRule parseRule(String rule) throws MatchRuleParseException {
        DefaultMatchRuleParser parser = new DefaultMatchRuleParser();
        return parser.parse(rule);
    }

    public static DefaultMatchRuleParser create() {
        DefaultMatchRuleParser parser = new DefaultMatchRuleParser();
        parser.setMultiCharWildcardMatchesEmptyString(true);
        return parser;
    }

    public static DefaultMatchRuleParser create(MatchRuleChars chars) {
        DefaultMatchRuleParser parser = new DefaultMatchRuleParser(chars);
        parser.setMultiCharWildcardMatchesEmptyString(true);
        return parser;
    }

    public DefaultMatchRuleParser() {
    }

    public DefaultMatchRuleParser(MatchRuleChars ruleCharacters) {
        this();
        if (ruleCharacters != null) {
            this.setRuleChars(ruleCharacters);
        }
    }

    public MatchRule parse(String rule) throws MatchRuleParseException {
        MatchGroup group = this.parseToGroup(rule);
        if (group == null) {
            return null;
        }
        return this.createMatchRuleOn(group);
    }

    public MatchRule parseTypedRule(String rule, Map datatypes) throws MatchRuleException {
        MatchRule matchRule = this.parse(rule);
        matchRule.setDatatypes(datatypes);
        return matchRule;
    }

    public char getAndChar() {
        return this.getRuleChars().getAndChar();
    }

    public void setAndChar(char newValue) {
        this.getRuleChars().setAndChar(newValue);
    }

    public char getOrChar() {
        return this.getRuleChars().getOrChar();
    }

    public void setOrChar(char newValue) {
        this.getRuleChars().setOrChar(newValue);
    }

    public char getNotChar() {
        return this.getRuleChars().getNotChar();
    }

    public void setNotChar(char newValue) {
        this.getRuleChars().setNotChar(newValue);
    }

    public char getValueSeparatorChar() {
        return this.getRuleChars().getValueSeparatorChar();
    }

    public void setValueSeparatorChar(char newValue) {
        this.getRuleChars().setValueSeparatorChar(newValue);
    }

    public char getValueDelimiterChar() {
        return this.getRuleChars().getValueDelimiterChar();
    }

    public char getValueStartChar() {
        return this.getRuleChars().getValueStartChar();
    }

    public void setValueStartChar(char newValue) {
        this.getRuleChars().setValueStartChar(newValue);
    }

    public char getValueEndChar() {
        return this.getRuleChars().getValueEndChar();
    }

    public void setValueEndChar(char newValue) {
        this.getRuleChars().setValueEndChar(newValue);
    }

    public char getGroupStartChar() {
        return this.getRuleChars().getGroupStartChar();
    }

    public void setGroupStartChar(char newValue) {
        this.getRuleChars().setGroupStartChar(newValue);
    }

    public char getGroupEndChar() {
        return this.getRuleChars().getGroupEndChar();
    }

    public void setGroupEndChar(char newValue) {
        this.getRuleChars().setGroupEndChar(newValue);
    }

    public char getGreaterChar() {
        return this.getRuleChars().getGreaterChar();
    }

    public void setGreaterChar(char newValue) {
        this.getRuleChars().setGreaterChar(newValue);
    }

    public char getLessChar() {
        return this.getRuleChars().getLessChar();
    }

    public void setLessChar(char newValue) {
        this.getRuleChars().setLessChar(newValue);
    }

    public char getEqualsChar() {
        return this.getRuleChars().getEqualsChar();
    }

    public void setEqualsChar(char newValue) {
        this.getRuleChars().setEqualsChar(newValue);
    }

    protected MatchGroup parseToGroup(String rule) throws MatchRuleParseException {
        if (rule == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(rule.length() + 2);
        buffer.append(this.getGroupStartChar());
        buffer.append(rule);
        buffer.append(this.getGroupEndChar());
        this.scanner(new StringScanner(buffer.toString()));
        MatchGroup group = this.parseGroup();
        this.checkExpectedEnd(this.scanner().peek());
        return group;
    }

    protected MatchGroup parseGroup() throws MatchRuleParseException {
        char ch = ' ';
        boolean enclosed = false;
        MatchGroup group = new MatchGroup();
        this.readOperators(group);
        ch = this.scanner().nextNoneWhitespaceChar();
        if (ch == this.getGroupStartChar()) {
            enclosed = true;
        } else {
            this.scanner().skip(-1);
        }
        this.readElements(group);
        ch = this.scanner().peek();
        if (enclosed) {
            this.checkUnexpectedEnd(ch);
            if (this.isGroupEnd(ch)) {
                this.scanner().nextChar();
            } else {
                this.scanner().skip(-1);
                this.throwException("Expected '" + this.getGroupEndChar() + "', but found '" + ch + "' at position " + this.scanner().getPosition());
            }
        } else {
            this.checkExpectedEnd(ch);
        }
        return group;
    }

    protected void readElements(MatchGroup group) throws MatchRuleParseException {
        char ch = ' ';
        ch = this.scanner().peek();
        this.checkUnexpectedEnd(ch);
        do {
            group.addElement(this.readElement());
            ch = this.scanner().nextNoneWhitespaceChar();
            if (this.atEnd(ch)) continue;
            this.scanner().skip(-1);
        } while (this.isOperator(ch));
    }

    protected MatchElement readElement() throws MatchRuleParseException {
        MatchElement element = null;
        element = this.nextIsGroupElement() ? this.parseGroup() : this.parseAttribute();
        return element;
    }

    protected boolean nextIsGroupElement() throws MatchRuleParseException {
        char ch = ' ';
        boolean isGroup = false;
        this.scanner().markPosition();
        ch = this.scanner().nextNoneWhitespaceChar();
        while (this.isOperator(ch) || ch == this.getNotChar()) {
            ch = this.scanner().nextNoneWhitespaceChar();
        }
        if (ch == this.getGroupStartChar()) {
            isGroup = true;
        }
        this.scanner().restorePosition();
        return isGroup;
    }

    protected MatchAttribute parseAttribute() throws MatchRuleParseException {
        if (this.scanner().length() < 3) {
            this.throwException("Impossible length for attribute at position : " + this.scanner().getPosition());
        }
        MatchAttribute attr = new MatchAttribute();
        this.readOperators(attr);
        this.readAttributeName(attr);
        char ch = this.readCompareOperator(attr);
        if (ch == this.getValueStartChar()) {
            this.readMatchValues(attr);
        } else {
            this.readMatchValue(attr);
        }
        return attr;
    }

    protected void readAttributeName(MatchAttribute attribute) throws MatchRuleParseException {
        StringBuffer strbuf = new StringBuffer(40);
        char ch = this.scanner().nextNoneWhitespaceChar();
        while (this.isValidNameCharacter(ch)) {
            strbuf.append(ch);
            ch = this.scanner().nextChar();
        }
        if (ch == ' ') {
            ch = this.scanner().nextNoneWhitespaceChar();
        }
        this.checkUnexpectedEnd(ch);
        if (this.isValidCompareOperator(ch)) {
            this.scanner().skip(-1);
        } else {
            this.throwException("Invalid character '" + ch + "' in " + "attribute \"" + this.scanner().toString() + "\"");
        }
        attribute.setAttributeName(strbuf.toString());
    }

    protected boolean isValidCompareOperator(char ch) {
        if (ch == this.getValueStartChar()) {
            return true;
        }
        if (ch == this.getEqualsChar()) {
            return true;
        }
        if (ch == this.getGreaterChar()) {
            return true;
        }
        return ch == this.getLessChar();
    }

    protected char readCompareOperator(MatchAttribute attribute) throws MatchRuleParseException {
        char ch = this.scanner().nextNoneWhitespaceChar();
        this.checkUnexpectedEnd(ch);
        if (ch == this.getValueStartChar() || ch == this.getEqualsChar()) {
            attribute.setEqualsOperator();
            return ch;
        }
        if (ch == this.getGreaterChar()) {
            if (this.scanner().peek() == this.getEqualsChar()) {
                ch = this.scanner().nextChar();
                attribute.setGreaterOrEqualOperator();
            } else {
                attribute.setGreaterOperator();
            }
            return ch;
        }
        if (ch == this.getLessChar()) {
            if (this.scanner().peek() == this.getEqualsChar()) {
                ch = this.scanner().nextChar();
                attribute.setLessOrEqualOperator();
            } else {
                attribute.setLessOperator();
            }
            return ch;
        }
        this.throwException("Invalid compare operator '" + ch + "' after " + "attribute \"" + this.scanner().toString() + "\"");
        return ch;
    }

    protected void readMatchValues(MatchAttribute attribute) throws MatchRuleParseException {
        char ch;
        ArrayList<StringPattern> patterns = new ArrayList<StringPattern>();
        StringPattern[] strPatterns = null;
        do {
            StringPattern pattern = this.readMatchValue();
            patterns.add(pattern);
            ch = this.scanner().nextNoneWhitespaceChar();
            this.checkUnexpectedEnd(ch);
            if (ch == this.getValueSeparatorChar() || ch == this.getValueEndChar()) continue;
            this.scanner().skip(-1);
            this.throwException("Expected '" + this.getValueSeparatorChar() + "' or '" + this.getValueEndChar() + "' at position " + this.scanner().getPosition() + " but found '" + ch + "'");
        } while (ch != this.getValueEndChar());
        strPatterns = new StringPattern[patterns.size()];
        patterns.toArray(strPatterns);
        attribute.setPatterns(strPatterns);
    }

    protected void readMatchValue(MatchAttribute attribute) throws MatchRuleParseException {
        StringPattern pattern = this.readMatchValue();
        attribute.setPattern(pattern);
    }

    protected StringPattern readMatchValue() throws MatchRuleParseException {
        char ch = this.scanner().nextNoneWhitespaceChar();
        this.checkUnexpectedEnd(ch);
        String value = ch == this.getValueDelimiterChar() ? this.readDelimitedMatchValue() : this.readUndelimitedMatchValue(ch);
        return new StringPattern(value);
    }

    protected String readDelimitedMatchValue() throws MatchRuleParseException {
        char delimiter = this.getValueDelimiterChar();
        StringBuffer strbuf = new StringBuffer(40);
        char ch = this.scanner().nextChar();
        this.checkUnexpectedEnd(ch);
        while (ch != delimiter) {
            strbuf.append(ch);
            ch = this.scanner().nextChar();
            this.checkUnexpectedEnd(ch);
        }
        return strbuf.toString();
    }

    protected String readUndelimitedMatchValue(char ch) throws MatchRuleParseException {
        StringBuffer strbuf = new StringBuffer(40);
        while (this.isPartOfValue(ch)) {
            strbuf.append(ch);
            ch = this.scanner().nextChar();
        }
        if (!this.atEnd(ch)) {
            this.scanner().skip(-1);
        }
        return strbuf.toString().trim();
    }

    protected boolean isPartOfValue(char ch) {
        if (ch == this.getValueEndChar()) {
            return false;
        }
        if (ch == this.getValueSeparatorChar()) {
            return false;
        }
        return !this.isOperator(ch) && !this.isGroupEnd(ch) && !this.atEnd(ch);
    }

    protected void readOperators(MatchElement element) throws MatchRuleParseException {
        char ch = this.scanner().nextNoneWhitespaceChar();
        if (ch == this.getAndChar() || ch == this.getOrChar()) {
            element.setAnd(ch == this.getAndChar());
            if (this.scanner().nextNoneWhitespaceChar() == this.getNotChar()) {
                element.setNot(true);
            } else {
                this.scanner().skip(-1);
            }
        } else if (ch == this.getNotChar()) {
            element.setNot(true);
        } else {
            this.scanner().skip(-1);
        }
    }

    protected String readUpTo(char exitChar) throws MatchRuleParseException {
        StringBuffer strbuf = new StringBuffer(100);
        char ch = this.scanner().nextChar();
        while (ch != exitChar) {
            this.checkUnexpectedEnd(ch);
            strbuf.append(ch);
            ch = this.scanner().nextChar();
        }
        return strbuf.toString();
    }

    protected boolean isOperator(char ch) {
        return ch == this.getAndChar() || ch == this.getOrChar();
    }

    protected boolean isValidNameCharacter(char ch) {
        boolean valid = Character.isLetterOrDigit(ch);
        if (!valid) {
            valid = this.getSpecialNameCharacters().indexOf(ch) >= 0;
        }
        return valid;
    }

    protected boolean isGroupEnd(char ch) {
        return ch == this.getGroupEndChar();
    }

    protected String getSpecialNameCharacters() {
        return this.getRuleChars().getSpecialNameCharacters();
    }

    protected MatchRule createMatchRuleOn(MatchGroup group) {
        MatchRule matchRule = new MatchRule(group);
        if (this.getIgnoreCaseInNames()) {
            matchRule.ignoreCaseInNames(true);
        }
        if (this.getIgnoreCaseInValues()) {
            matchRule.ignoreCase(true);
        }
        if (this.getMultiCharWildcardMatchesEmptyString()) {
            matchRule.multiCharWildcardMatchesEmptyString(true);
        }
        return matchRule;
    }
}

