/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import org.pf.text.BaseMatchRuleParser;
import org.pf.text.MatchAttribute;
import org.pf.text.MatchElement;
import org.pf.text.MatchGroup;
import org.pf.text.MatchRule;
import org.pf.text.MatchRuleParseException;
import org.pf.text.StringPattern;
import org.pf.text.StringScanner;

public class LdapFilterParser
extends BaseMatchRuleParser {
    private static final char ELEMENT_START = '(';
    private static final char ELEMENT_END = ')';
    private static final char OPERATOR_AND = '&';
    private static final char OPERATOR_OR = '|';
    private static final char OPERATOR_NOT = '!';
    private static final char EQUALS_COMPARATOR = '=';
    private static final char GREATER_COMPARATOR = '>';
    private static final char LESS_COMPARATOR = '<';

    public static MatchRule parseFilter(String filter) throws MatchRuleParseException {
        LdapFilterParser parser = new LdapFilterParser();
        return parser.parse(filter);
    }

    public MatchRule parse(String filter) throws MatchRuleParseException {
        MatchGroup group = this.parseToGroup(filter);
        if (group == null) {
            return null;
        }
        return this.createMatchRuleOn(group);
    }

    protected MatchGroup parseToGroup(String filter) throws MatchRuleParseException {
        if (filter == null) {
            return null;
        }
        this.scanner(new StringScanner(filter));
        return this.parse();
    }

    protected MatchGroup parse() throws MatchRuleParseException {
        MatchGroup group;
        MatchElement element;
        char ch = this.scanner().nextNoneWhitespaceChar();
        this.checkUnexpectedEnd(ch);
        if (ch == '(') {
            element = this.parseElement();
            this.checkNextClosingParenthesis();
            group = new MatchGroup();
            group.addElement(element);
            element = group;
        } else {
            this.scanner().skip(-1);
            element = this.parseAttribute();
            ch = this.scanner().nextChar();
            if (!this.atEnd(ch)) {
                this.throwException("End expected, but found '" + ch + "'");
            }
        }
        if (element.isGroup()) {
            group = (MatchGroup)element;
        } else {
            group = new MatchGroup();
            group.addElement(element);
        }
        return group;
    }

    protected MatchElement parseElement() throws MatchRuleParseException {
        MatchElement element = null;
        char ch = this.scanner().nextNoneWhitespaceChar();
        this.checkUnexpectedEnd(ch);
        if (this.isOperator(ch)) {
            element = this.parseGroup(ch);
        } else if (this.isNotOperator(ch)) {
            element = this.parseNotElement();
        } else if (this.isLiteral(ch)) {
            this.scanner().skip(-1);
            element = this.parseAttribute();
        } else {
            this.throwException("Unexpected character '" + ch + "' at position " + (this.scanner().getPosition() - 1));
        }
        return element;
    }

    protected MatchElement parseNotElement() throws MatchRuleParseException {
        MatchElement element = null;
        this.checkNextOpeningParenthesis();
        element = this.parseElement();
        this.checkNextClosingParenthesis();
        element.setNot(true);
        return element;
    }

    protected MatchGroup parseGroup(char operator) throws MatchRuleParseException {
        MatchGroup group = null;
        MatchElement element = null;
        boolean andOperator = true;
        char ch = this.checkNextOpeningParenthesis();
        andOperator = operator != '|';
        group = new MatchGroup();
        while (!this.atEnd(ch) && ch == '(') {
            element = this.parseElement();
            group.addElement(element);
            if (group.elementCount() > 1) {
                element.setAnd(andOperator);
            }
            this.checkNextClosingParenthesis();
            ch = this.scanner().nextNoneWhitespaceChar();
        }
        if (ch != ')') {
            this.parenthesisExpected("Closing");
        }
        this.scanner().skip(-1);
        return group;
    }

    protected MatchAttribute parseAttribute() throws MatchRuleParseException {
        StringBuffer buffer = new StringBuffer(30);
        char ch = this.scanner().nextChar();
        while (!this.atEnd(ch) && this.isValidAttributeNameCharacter(ch)) {
            buffer.append(ch);
            ch = this.scanner().nextChar();
        }
        this.checkUnexpectedEnd(ch);
        MatchAttribute matchAttr = new MatchAttribute();
        matchAttr.setAttributeName(buffer.toString());
        if (ch == '>') {
            matchAttr.setGreaterOrEqualOperator();
            ch = this.scanner().nextChar();
        } else if (ch == '<') {
            matchAttr.setLessOrEqualOperator();
            ch = this.scanner().nextChar();
        }
        if (ch != '=' || this.scanner().peek() == '~') {
            this.throwException("Unsupported or invalid operator '" + ch + "' at position " + this.scanner().getPosition());
        }
        buffer = new StringBuffer(30);
        ch = this.scanner().nextChar();
        while (!this.atEnd(ch) && ch != ')') {
            buffer.append(ch);
            ch = this.scanner().nextChar();
        }
        matchAttr.setPattern(new StringPattern(buffer.toString(), true));
        if (ch == ')') {
            this.scanner().skip(-1);
        }
        return matchAttr;
    }

    protected boolean isNotOperator(char ch) {
        return ch == '!';
    }

    protected boolean isOperator(char ch) {
        return ch == '&' || ch == '|';
    }

    protected boolean isLiteral(char ch) {
        return Character.isJavaIdentifierStart(ch);
    }

    protected boolean isValidAttributeNameCharacter(char ch) {
        return this.isLiteral(ch) || Character.isDigit(ch);
    }

    protected void parenthesisExpected(String prefix) throws MatchRuleParseException {
        this.throwException(String.valueOf(prefix) + " parenthesis expected at position " + this.scanner().getPosition());
    }

    protected char checkNextOpeningParenthesis() throws MatchRuleParseException {
        char ch = this.scanner().nextNoneWhitespaceChar();
        this.checkUnexpectedEnd(ch);
        if (ch != '(') {
            this.parenthesisExpected("Opening");
        }
        return ch;
    }

    protected char checkNextClosingParenthesis() throws MatchRuleParseException {
        char ch = this.scanner().nextNoneWhitespaceChar();
        this.checkUnexpectedEnd(ch);
        if (ch != ')') {
            this.parenthesisExpected("Closing");
        }
        return ch;
    }

    protected MatchRule createMatchRuleOn(MatchGroup group) {
        MatchRule matchRule = new MatchRule(group);
        matchRule.ignoreCaseInNames(true);
        matchRule.ignoreCase(true);
        matchRule.multiCharWildcardMatchesEmptyString(true);
        return matchRule;
    }
}

