/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.pf.text.MatchElement;
import org.pf.text.MatchRuleException;
import org.pf.text.MatchRuleVisitor;
import org.pf.text.StringPattern;

public class MatchAttribute
extends MatchElement
implements Serializable {
    public static final int OPERATOR_EQUALS = 1;
    public static final int OPERATOR_GREATER = 2;
    public static final int OPERATOR_LESS = 3;
    public static final int OPERATOR_GREATER_OR_EQUAL = 4;
    public static final int OPERATOR_LESS_OR_EQUAL = 5;
    private int operator = 1;
    private String attributeName = null;
    private StringPattern[] patterns = null;
    private boolean ignoreCaseInName = false;
    private Object valueType = null;
    private Float[] floatValues = null;
    private Double[] doubleValues = null;
    private BigDecimal[] bigDecimalValues = null;
    private Integer[] integerValues = null;
    private Long[] longValues = null;
    private Date[] dateValues = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;

    protected int operator() {
        return this.operator;
    }

    protected void operator(int newValue) {
        this.operator = newValue;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String newValue) {
        this.attributeName = newValue;
    }

    public StringPattern[] getPatterns() {
        return this.patterns;
    }

    public void setPatterns(StringPattern[] newValue) {
        this.patterns = newValue;
    }

    public boolean ignoreCaseInName() {
        return this.ignoreCaseInName;
    }

    protected void ignoreCaseInName(boolean newValue) {
        this.ignoreCaseInName = newValue;
    }

    protected Object getValueType() {
        return this.valueType;
    }

    protected void setValueType(Object newValue) {
        this.valueType = newValue;
    }

    public MatchAttribute() {
    }

    public MatchAttribute(String name) {
        this.setAttributeName(name);
    }

    public boolean isAttribute() {
        return true;
    }

    public void setPattern(StringPattern aPattern) {
        StringPattern[] p = new StringPattern[]{aPattern};
        this.setPatterns(p);
    }

    public String toString() {
        StringBuffer str = new StringBuffer(40);
        boolean hasValueList = false;
        if (this.getNot()) {
            str.append('!');
        }
        str.append(this.getAttributeName());
        boolean bl = hasValueList = this.getPatterns().length > 1;
        if (hasValueList) {
            str.append('{');
            int i = 0;
            while (i < this.getPatterns().length) {
                if (i > 0) {
                    str.append(',');
                }
                str.append(this.getPatterns()[i].getPattern());
                ++i;
            }
            str.append('}');
        } else {
            switch (this.operator()) {
                case 1: {
                    str.append('=');
                    break;
                }
                case 2: {
                    str.append('>');
                    break;
                }
                case 4: {
                    str.append('>');
                    str.append('=');
                    break;
                }
                case 3: {
                    str.append('<');
                    break;
                }
                case 5: {
                    str.append('<');
                    str.append('=');
                }
            }
            str.append(this.getPatterns()[0].toString());
        }
        return str.toString();
    }

    public void setEqualsOperator() {
        this.operator(1);
    }

    public void setGreaterOperator() {
        this.operator(2);
    }

    public void setLessOperator() {
        this.operator(3);
    }

    public void setGreaterOrEqualOperator() {
        this.operator(4);
    }

    public void setLessOrEqualOperator() {
        this.operator(5);
    }

    public void setDatatype(Object type) throws MatchRuleException {
        block8: {
            block7: {
                if (type == null) break block7;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.lang.String");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (type != clazz) break block8;
            }
            this.setValueType(null);
            return;
        }
        this.convertToType(type);
        this.setValueType(type);
    }

    protected boolean doMatch(Map dictionary) {
        Object value = null;
        value = this.valueInMap(dictionary);
        if (value == null) {
            return false;
        }
        if (this.isTyped()) {
            return this.doTypedMatch(value);
        }
        if (value instanceof String) {
            return this.matchValue(value);
        }
        if (value instanceof String[]) {
            return this.matchValueArray((Object[])value);
        }
        if (value instanceof List) {
            return this.matchValueList((List)value);
        }
        if (value instanceof Integer) {
            return this.matchValue(value);
        }
        if (value instanceof Integer[]) {
            return this.matchValueArray((Object[])value);
        }
        return false;
    }

    protected boolean doTypedMatch(Object value) {
        if (this.isCorrectType(value)) {
            try {
                Object object = this.getValueType();
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (object == clazz) {
                    return this.doFloatMatch(value);
                }
                Object object2 = this.getValueType();
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (object2 == clazz2) {
                    return this.doDoubleMatch(value);
                }
                Object object3 = this.getValueType();
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (object3 == clazz3) {
                    return this.doBigDecimalMatch(value);
                }
                Object object4 = this.getValueType();
                Class<?> clazz4 = class$4;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$4 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (object4 == clazz4) {
                    return this.doIntegerMatch(value);
                }
                Object object5 = this.getValueType();
                Class<?> clazz5 = class$5;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$5 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (object5 == clazz5) {
                    return this.doLongMatch(value);
                }
                if (this.getValueType() instanceof SimpleDateFormat) {
                    return this.doDateMatch(value);
                }
            }
            catch (RuntimeException e) {
                return false;
            }
        }
        return false;
    }

    protected boolean isCorrectType(Object value) {
        if (this.getValueType() instanceof SimpleDateFormat) {
            Class<?> clazz = value.getClass();
            Class<?> clazz2 = class$6;
            if (clazz2 == null) {
                try {
                    clazz2 = class$6 = Class.forName("java.util.Date");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clazz == clazz2) {
                return true;
            }
        }
        return this.getValueType() == this.getTypeOf(value);
    }

    protected boolean doFloatMatch(Object value) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Float[] dataValues = (Float[])this.toArray(value, clazz);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.floatValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean doDoubleMatch(Object value) {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Double[] dataValues = (Double[])this.toArray(value, clazz);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.doubleValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean doBigDecimalMatch(Object value) {
        Class<?> clazz = class$3;
        if (clazz == null) {
            try {
                clazz = class$3 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BigDecimal[] dataValues = (BigDecimal[])this.toArray(value, clazz);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.bigDecimalValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean doIntegerMatch(Object value) {
        Class<?> clazz = class$4;
        if (clazz == null) {
            try {
                clazz = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Integer[] dataValues = (Integer[])this.toArray(value, clazz);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.integerValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean doLongMatch(Object value) {
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Long[] dataValues = (Long[])this.toArray(value, clazz);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.longValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean doDateMatch(Object value) {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("java.util.Date");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Date[] dataValues = (Date[])this.toArray(value, clazz);
        int i = 0;
        while (i < dataValues.length) {
            if (this.matchValueAgainstValues(dataValues[i], this.dateValues)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matchValueArray(Object[] values) {
        int i = 0;
        while (i < values.length) {
            if (this.matchValue(values[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matchValueList(List values) {
        Iterator iterator = values.iterator();
        String value = null;
        while (iterator.hasNext()) {
            try {
                value = (String)iterator.next();
                if (!this.matchValue(value)) continue;
                return true;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return false;
    }

    protected boolean matchValue(Object value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        while (i < this.getPatterns().length) {
            String strValue;
            StringPattern pattern = this.getPatterns()[i];
            if (this.operator() == 1 && pattern.hasWildcard() ? pattern.matches(strValue = value.toString()) : (value instanceof String ? this.compare((String)value, pattern.toString(), pattern.getIgnoreCase()) : value instanceof Integer && this.compare((Integer)value, pattern.toString()))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean matchValueAgainstValues(Comparable value, Object[] values) {
        if (value == null) {
            return false;
        }
        int i = 0;
        while (i < values.length) {
            int result = value.compareTo(values[i]);
            if (this.compareIntegers(result, 0)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean compare(String value, String ruleValue, boolean ignoreCase) {
        int result = ignoreCase ? value.compareToIgnoreCase(ruleValue) : value.compareTo(ruleValue);
        return this.compareIntegers(result, 0);
    }

    protected boolean compare(Integer value, String ruleValue) {
        int ruleIntValue;
        try {
            ruleIntValue = Integer.parseInt(ruleValue);
        }
        catch (RuntimeException e) {
            return false;
        }
        return this.compareIntegers(value, ruleIntValue);
    }

    protected boolean compareIntegers(int a, int b) {
        switch (this.operator()) {
            case 1: {
                return a == b;
            }
            case 4: {
                return a >= b;
            }
            case 5: {
                return a <= b;
            }
            case 2: {
                return a > b;
            }
            case 3: {
                return a < b;
            }
        }
        return false;
    }

    protected void ignoreCase(boolean ignoreIt) {
        int i = 0;
        while (i < this.getPatterns().length) {
            this.getPatterns()[i].setIgnoreCase(ignoreIt);
            ++i;
        }
    }

    protected void multiCharWildcardMatchesEmptyString(boolean yesOrNo) {
        int i = 0;
        while (i < this.getPatterns().length) {
            this.getPatterns()[i].multiCharWildcardMatchesEmptyString(yesOrNo);
            ++i;
        }
    }

    protected void apply(MatchRuleVisitor visitor) {
        String[] values = new String[this.getPatterns().length];
        int i = 0;
        while (i < this.getPatterns().length) {
            values[i] = this.getPatterns()[i].getPattern();
            ++i;
        }
        visitor.attribute(this.getAttributeName(), this.operator(), values, this.getAnd(), this.getNot());
    }

    protected Object valueInMap(Map map) {
        String attrName = this.nameOfAttribute(map);
        if (attrName == null) {
            return null;
        }
        return map.get(attrName);
    }

    protected String nameOfAttribute(Map map) {
        String name = this.getAttributeName();
        if (this.ignoreCaseInName()) {
            Set keyNames = map.keySet();
            Iterator iterator = keyNames.iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                if (!name.equalsIgnoreCase(key)) continue;
                return key;
            }
            name = null;
        }
        return name;
    }

    protected void convertToType(Object type) throws MatchRuleException {
        String[] strValues = new String[this.getPatterns().length];
        int i = 0;
        while (i < this.getPatterns().length) {
            strValues[i] = this.getPatterns()[i].getPattern();
            ++i;
        }
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.lang.Float");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz) {
            this.convertToFloat(strValues);
            return;
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("java.lang.Double");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz2) {
            this.convertToDouble(strValues);
            return;
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("java.math.BigDecimal");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz3) {
            this.convertToBigDecimal(strValues);
            return;
        }
        Class<?> clazz4 = class$4;
        if (clazz4 == null) {
            try {
                clazz4 = class$4 = Class.forName("java.lang.Integer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz4) {
            this.convertToInteger(strValues);
            return;
        }
        Class<?> clazz5 = class$5;
        if (clazz5 == null) {
            try {
                clazz5 = class$5 = Class.forName("java.lang.Long");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (type == clazz5) {
            this.convertToLong(strValues);
            return;
        }
        if (type instanceof SimpleDateFormat) {
            this.convertToDate(strValues, (SimpleDateFormat)type);
            return;
        }
        throw new MatchRuleException("Type " + type + " not supported.");
    }

    protected void convertToFloat(String[] strValues) throws MatchRuleException {
        this.floatValues = new Float[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.floatValues[i] = Float.valueOf(strValues[i]);
            }
            catch (NumberFormatException e) {
                String string = strValues[i];
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.lang.Float");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw this.createTypeConversionException(string, clazz);
            }
            ++i;
        }
    }

    protected void convertToDouble(String[] strValues) throws MatchRuleException {
        this.doubleValues = new Double[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.doubleValues[i] = Double.valueOf(strValues[i]);
            }
            catch (NumberFormatException e) {
                String string = strValues[i];
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.lang.Double");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw this.createTypeConversionException(string, clazz);
            }
            ++i;
        }
    }

    protected void convertToBigDecimal(String[] strValues) throws MatchRuleException {
        this.bigDecimalValues = new BigDecimal[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.bigDecimalValues[i] = new BigDecimal(strValues[i]);
            }
            catch (NumberFormatException e) {
                String string = strValues[i];
                Class<?> clazz = class$3;
                if (clazz == null) {
                    try {
                        clazz = class$3 = Class.forName("java.math.BigDecimal");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw this.createTypeConversionException(string, clazz);
            }
            ++i;
        }
    }

    protected void convertToInteger(String[] strValues) throws MatchRuleException {
        this.integerValues = new Integer[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.integerValues[i] = Integer.valueOf(strValues[i]);
            }
            catch (NumberFormatException e) {
                String string = strValues[i];
                Class<?> clazz = class$4;
                if (clazz == null) {
                    try {
                        clazz = class$4 = Class.forName("java.lang.Integer");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw this.createTypeConversionException(string, clazz);
            }
            ++i;
        }
    }

    protected void convertToLong(String[] strValues) throws MatchRuleException {
        this.longValues = new Long[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.longValues[i] = Long.valueOf(strValues[i]);
            }
            catch (NumberFormatException e) {
                String string = strValues[i];
                Class<?> clazz = class$5;
                if (clazz == null) {
                    try {
                        clazz = class$5 = Class.forName("java.lang.Long");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                throw this.createTypeConversionException(string, clazz);
            }
            ++i;
        }
    }

    protected void convertToDate(String[] strValues, SimpleDateFormat dateFormat) throws MatchRuleException {
        this.dateValues = new Date[strValues.length];
        int i = 0;
        while (i < strValues.length) {
            try {
                this.dateValues[i] = dateFormat.parse(strValues[i]);
            }
            catch (ParseException e) {
                throw new MatchRuleException("Unable to convert '" + strValues[i] + "' to Date with format \"" + dateFormat.toPattern() + "\" for attribute <" + this.getAttributeName() + ">");
            }
            ++i;
        }
    }

    protected MatchRuleException createTypeConversionException(String value, Class type) {
        return new MatchRuleException("Unable to convert '" + value + "' to " + type + " for attribute <" + this.getAttributeName() + ">");
    }

    protected boolean isTyped() {
        return this.getValueType() != null;
    }

    protected Class getTypeOf(Object object) {
        try {
            if (object instanceof List) {
                return ((List)object).get(0).getClass();
            }
            if (object.getClass().isArray()) {
                return object.getClass().getComponentType();
            }
            return object.getClass();
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    protected Object[] toArray(Object object, Class type) {
        if (object instanceof List) {
            List list = (List)object;
            Object[] array = (Object[])Array.newInstance(type, list.size());
            return list.toArray(array);
        }
        if (object.getClass().isArray()) {
            return (Object[])object;
        }
        Object[] array = (Object[])Array.newInstance(type, 1);
        array[0] = object;
        return array;
    }

    protected void applyDatatypes(Map datatypes) throws MatchRuleException {
        this.setDatatype(this.valueInMap(datatypes));
    }
}

