/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import org.pf.text.MatchRule;
import org.pf.text.MatchRuleVisitor;

public class SqlMatchRuleVisitor
implements MatchRuleVisitor {
    protected static final char MULTICHAR_WILDCARD = '%';
    protected static final String SQL_OPERATOR_NOT = "NOT ";
    protected static final String SQL_OPERATOR_AND = "AND ";
    protected static final String SQL_OPERATOR_OR = "OR ";
    protected static final String SQL_OPERATOR_IN = "IN ";
    protected static final String SQL_OPERATOR_LIKE = "LIKE ";
    protected static final String SQL_OPERATOR_EQUAL = "= ";
    protected static final String SQL_OPERATOR_GE = ">= ";
    protected static final String SQL_OPERATOR_LE = "<= ";
    protected static final String SQL_OPERATOR_GREATER = "> ";
    protected static final String SQL_OPERATOR_LESS = "< ";
    protected static final String OPEN_PARENTHESIS = "( ";
    protected static final String CLOSE_PARENTHESIS = ") ";
    protected static final String COMMA = ", ";
    protected static final String START_QUOTE = "'";
    protected static final String END_QUOTE = "' ";
    private StringBuffer buffer = null;
    private boolean groupStarted = true;

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected void setBuffer(StringBuffer newValue) {
        this.buffer = newValue;
    }

    protected boolean groupStarted() {
        return this.groupStarted;
    }

    protected void groupStarted(boolean newValue) {
        this.groupStarted = newValue;
    }

    public void walkThroughInit() {
        this.setBuffer(new StringBuffer(100));
        this.groupStarted(true);
    }

    public void walkThroughFinished() {
    }

    public void startGroup(boolean andOperator, boolean notOperator) {
        this.appendOperators(andOperator, notOperator);
        this.getBuffer().append(OPEN_PARENTHESIS);
        this.groupStarted(true);
    }

    public void endGroup() {
        this.getBuffer().append(CLOSE_PARENTHESIS);
        this.groupStarted(false);
    }

    public void attribute(String name, int compareOperator, String[] values, boolean andOperator, boolean notOperator) {
        this.appendOperators(andOperator, notOperator);
        if (this.canBeInOperator(compareOperator, values)) {
            this.append_IN(name, values);
        } else {
            this.appendAttributeValues(name, compareOperator, values);
        }
        this.groupStarted(false);
    }

    public String asSqlClause(MatchRule matchRule) {
        matchRule.apply(this);
        return this.getBuffer().toString().trim();
    }

    protected void appendOperators(boolean andOperator, boolean notOperator) {
        if (!this.groupStarted()) {
            this.getBuffer().append(andOperator ? SQL_OPERATOR_AND : SQL_OPERATOR_OR);
        }
        if (notOperator) {
            this.getBuffer().append(SQL_OPERATOR_NOT);
        }
    }

    protected void appendAttribute(String name, int compareOperator, String value) {
        this.getBuffer().append(name);
        this.getBuffer().append(' ');
        if (compareOperator == 1) {
            if (value.indexOf(42) >= 0) {
                value = value.replace('*', '%');
                this.getBuffer().append(SQL_OPERATOR_LIKE);
            } else {
                this.getBuffer().append(SQL_OPERATOR_EQUAL);
            }
        } else {
            switch (compareOperator) {
                case 2: {
                    this.getBuffer().append(SQL_OPERATOR_GREATER);
                    break;
                }
                case 3: {
                    this.getBuffer().append(SQL_OPERATOR_LESS);
                    break;
                }
                case 4: {
                    this.getBuffer().append(SQL_OPERATOR_GE);
                    break;
                }
                case 5: {
                    this.getBuffer().append(SQL_OPERATOR_LE);
                }
            }
        }
        this.appendValue(value);
    }

    protected void appendValue(String value) {
        this.getBuffer().append(START_QUOTE);
        this.getBuffer().append(value);
        this.getBuffer().append(END_QUOTE);
    }

    protected void appendAttributeValues(String name, int compareOperator, String[] values) {
        boolean manyValues;
        boolean bl = manyValues = values.length > 1;
        if (manyValues) {
            this.getBuffer().append(OPEN_PARENTHESIS);
        }
        this.appendAttribute(name, compareOperator, values[0]);
        int i = 1;
        while (i < values.length) {
            this.getBuffer().append(SQL_OPERATOR_OR);
            this.appendAttribute(name, compareOperator, values[i]);
            ++i;
        }
        if (manyValues) {
            this.getBuffer().append(CLOSE_PARENTHESIS);
        }
    }

    protected void append_IN(String attrName, String[] values) {
        this.getBuffer().append(attrName);
        this.getBuffer().append(' ');
        this.getBuffer().append(SQL_OPERATOR_IN);
        this.getBuffer().append(OPEN_PARENTHESIS);
        int i = 0;
        while (i < values.length) {
            if (i > 0) {
                this.getBuffer().append(COMMA);
            }
            this.appendValue(values[i]);
            ++i;
        }
        this.getBuffer().append(CLOSE_PARENTHESIS);
    }

    protected boolean canBeInOperator(int compareOperator, String[] values) {
        if (compareOperator != 1) {
            return false;
        }
        if (values.length < 2) {
            return false;
        }
        int i = 0;
        while (i < values.length) {
            if (values[i].indexOf(42) >= 0) {
                return false;
            }
            if (values[i].indexOf(63) >= 0) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

