/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.util.Collection;
import org.pf.text.AStringFilter;
import org.pf.text.StringUtil;

public class StringCollectionFilter
extends AStringFilter {
    private String[] internalStrings = null;
    private boolean unchanged = true;
    private boolean ignoreCase = true;

    protected String[] getInternalStrings() {
        return this.internalStrings;
    }

    protected void setInternalStrings(String[] newValue) {
        this.internalStrings = newValue;
    }

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean newValue) {
        this.ignoreCase = newValue;
    }

    public StringCollectionFilter(String[] strings) {
        this.setInternalStrings(strings);
    }

    public StringCollectionFilter(Collection strings) {
        this.setInternalStrings(this.str().asStrings(strings));
    }

    public StringCollectionFilter(String strings, String separators) {
        this.setInternalStrings(this.str().parts(strings, separators));
    }

    public StringCollectionFilter(String strings) {
        this(strings, ",");
    }

    public boolean matches(String string) {
        if (string == null || this.getInternalStrings() == null) {
            return false;
        }
        boolean inArray = this.str().contains(this.getInternalStrings(), string, this.getIgnoreCase());
        return this.unchanged ? inArray : !inArray;
    }

    public void negate() {
        this.unchanged = !this.unchanged;
    }

    public boolean matchesIfInCollection() {
        return this.unchanged;
    }

    public void add(String string) {
        if (string != null) {
            String[] newArray = this.getInternalStrings() == null ? new String[]{string} : this.str().append(this.getInternalStrings(), string);
            this.setInternalStrings(newArray);
        }
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

