/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.io.Serializable;
import java.util.ArrayList;
import org.pf.text.AStringFilter;
import org.pf.text.StringExaminer;
import org.pf.text.StringUtil;

public class StringPattern
extends AStringFilter
implements Serializable {
    protected static final char DEFAULT_MULTICHAR_WILDCARD = '*';
    protected static final char DEFAULT_SINGLECHAR_WILDCARD = '?';
    protected static final String SWITCH_ON = "+";
    protected static final String SWITCH_OFF = "-";
    private static final String INSPECT_PREFIX = "StringPattern(";
    private static final String INSPECT_SEPARATOR = ",\"";
    private static final String INSPECT_SUFFIX = "\")";
    private boolean ignoreCase = false;
    private String pattern = null;
    private Character digitWildcard = null;
    private char singleCharWildcard = (char)63;
    private char multiCharWildcard = (char)42;
    private boolean multiCharWildcardMatchesEmptyString = false;

    public boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    public void setIgnoreCase(boolean newValue) {
        this.ignoreCase = newValue;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String newValue) {
        this.pattern = newValue;
    }

    protected Character digitWildcard() {
        return this.digitWildcard;
    }

    protected void digitWildcard(Character newValue) {
        this.digitWildcard = newValue;
    }

    public char getSingleCharWildcard() {
        return this.singleCharWildcard;
    }

    public void setSingleCharWildcard(char newValue) {
        this.singleCharWildcard = newValue;
    }

    public char getMultiCharWildcard() {
        return this.multiCharWildcard;
    }

    public void setMultiCharWildcard(char newValue) {
        this.multiCharWildcard = newValue;
    }

    public boolean multiCharWildcardMatchesEmptyString() {
        return this.multiCharWildcardMatchesEmptyString;
    }

    public void multiCharWildcardMatchesEmptyString(boolean newValue) {
        this.multiCharWildcardMatchesEmptyString = newValue;
    }

    public static StringPattern create(String pattern) {
        return StringPattern.create(pattern, false);
    }

    public static StringPattern create(String pattern, boolean ignoreCase) {
        StringPattern thePattern = new StringPattern(pattern, ignoreCase);
        thePattern.multiCharWildcardMatchesEmptyString(true);
        return thePattern;
    }

    public static StringPattern create(String pattern, char digitWildcard) {
        return StringPattern.create(pattern, false, digitWildcard);
    }

    public static StringPattern create(String pattern, boolean ignoreCase, char digitWildcard) {
        StringPattern thePattern = new StringPattern(pattern, ignoreCase, digitWildcard);
        thePattern.multiCharWildcardMatchesEmptyString(true);
        return thePattern;
    }

    public static boolean match(String probe, String pattern) {
        StringPattern stringPattern = new StringPattern(pattern, false);
        return stringPattern.matches(probe);
    }

    public static boolean matchIgnoreCase(String probe, String pattern) {
        StringPattern stringPattern = new StringPattern(pattern, true);
        return stringPattern.matches(probe);
    }

    public static char getDefaultMultiCharWildcard() {
        return '*';
    }

    public static char getDefaultSingleCharWildcard() {
        return '?';
    }

    public static boolean containsWildcard(String aString) {
        return aString != null && (aString.indexOf(42) >= 0 || aString.indexOf(63) >= 0);
    }

    public StringPattern(String pattern, boolean ignoreCase) {
        this.setPattern(pattern);
        this.setIgnoreCase(ignoreCase);
    }

    public StringPattern(String pattern) {
        this(pattern, false);
    }

    public StringPattern(String pattern, char digitWildcard) {
        this(pattern, false, digitWildcard);
    }

    public StringPattern(String pattern, boolean ignoreCase, char digitWildcard) {
        this.setPattern(pattern);
        this.setIgnoreCase(ignoreCase);
        this.setDigitWildcardChar(digitWildcard);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean matches(String probe) {
        StringExaminer patternIterator = null;
        StringExaminer probeIterator = null;
        char patternCh = '-';
        char probeCh = '-';
        String newPattern = null;
        String subPattern = null;
        int charIndex = 0;
        if (probe == null) {
            return false;
        }
        if (!this.multiCharWildcardMatchesEmptyString() && probe.length() == 0) {
            return this.getPattern().length() == 0;
        }
        patternIterator = this.newExaminer(this.getPattern());
        probeIterator = this.newExaminer(probe);
        probeCh = probeIterator.nextChar();
        patternCh = this.getPatternChar(patternIterator, probeCh);
        while (this.endNotReached(patternCh) && this.endNotReached(probeCh)) {
            if (patternCh == this.getMultiCharWildcard()) {
                patternCh = this.skipWildcards(patternIterator);
                if (this.endReached(patternCh)) {
                    return true;
                }
                patternIterator.skip(-1);
                newPattern = this.upToEnd(patternIterator);
                charIndex = newPattern.indexOf(this.getMultiCharWildcard());
                if (charIndex >= 0) {
                    subPattern = newPattern.substring(0, charIndex);
                    if (this.multiCharWildcardMatchesEmptyString()) {
                        probeIterator.skip(-1);
                    }
                    if (!this.skipAfter(probeIterator, subPattern)) return false;
                    patternIterator = this.newExaminer(newPattern.substring(charIndex));
                    patternCh = probeCh;
                } else {
                    probeIterator.skip(-1);
                    return this.matchReverse(newPattern, probeIterator);
                }
            }
            if (this.charsAreEqual(probeCh, patternCh)) {
                if (!this.endNotReached(patternCh)) continue;
                probeCh = probeIterator.nextChar();
                patternCh = this.getPatternChar(patternIterator, probeCh);
                continue;
            }
            if (patternCh == this.getMultiCharWildcard()) continue;
            return false;
        }
        return this.eventuallyMatched(probeCh, patternCh, patternIterator);
    }

    public String[] select(String[] strings) {
        return this.selectOrReject(strings, true);
    }

    public String[] reject(String[] strings) {
        return this.selectOrReject(strings, false);
    }

    public String toString() {
        if (this.getPattern() == null) {
            return super.toString();
        }
        return this.getPattern();
    }

    public boolean hasWildcard() {
        if (this.getPattern() == null) {
            return false;
        }
        if (this.hasDigitWildcard() && this.getPattern().indexOf(this.digitWildcardChar()) >= 0) {
            return true;
        }
        return StringPattern.containsWildcard(this.getPattern());
    }

    public void setDigitWildcardChar(char digitWildcard) {
        if (digitWildcard <= '\u0000') {
            this.digitWildcard(null);
        } else {
            this.digitWildcard(new Character(digitWildcard));
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof StringPattern) {
            StringPattern otherPattern = (StringPattern)obj;
            if (this.getIgnoreCase() != otherPattern.getIgnoreCase()) {
                return false;
            }
            return this.getPattern().equals(otherPattern.getPattern());
        }
        return false;
    }

    public int hashCode() {
        String temp = String.valueOf(this.ignoreCaseAsString()) + this.getPattern();
        return temp.hashCode();
    }

    protected boolean eventuallyMatched(char probeCh, char patternCh, StringExaminer patternIterator) {
        if (!this.endReached(probeCh)) {
            return false;
        }
        if (this.endReached(patternCh)) {
            return true;
        }
        if (this.multiCharWildcardMatchesEmptyString() && patternCh == this.getMultiCharWildcard()) {
            while (!patternIterator.atEnd()) {
                char ch = patternIterator.nextChar();
                if (ch == this.getMultiCharWildcard()) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected boolean hasDigitWildcard() {
        return this.digitWildcard() != null;
    }

    protected char digitWildcardChar() {
        if (this.hasDigitWildcard()) {
            return this.digitWildcard().charValue();
        }
        return '\u0000';
    }

    protected char skipWildcards(StringExaminer iterator) {
        char result = '-';
        while ((result = (char)iterator.nextChar()) == this.getMultiCharWildcard()) {
        }
        return result;
    }

    protected boolean skipAfter(StringExaminer examiner, String matchString) {
        char ch = '-';
        char matchChar = ' ';
        boolean found = false;
        int index = 0;
        if (matchString == null || matchString.length() == 0) {
            return false;
        }
        ch = examiner.nextChar();
        while (examiner.endNotReached(ch) && !found) {
            matchChar = matchString.charAt(index);
            if (this.charsAreEqual(ch, matchChar)) {
                if (++index >= matchString.length()) {
                    found = true;
                    continue;
                }
                ch = examiner.nextChar();
                continue;
            }
            if (index == 0) {
                ch = examiner.nextChar();
                continue;
            }
            index = 0;
        }
        return found;
    }

    protected String upToEnd(StringExaminer iterator) {
        return iterator.upToEnd();
    }

    protected boolean matchReverse(String patternStr, StringExaminer probeIterator) {
        String newPattern = String.valueOf(String.valueOf(this.getMultiCharWildcard())) + patternStr;
        String newProbe = this.upToEnd(probeIterator);
        newPattern = this.strUtil().reverse(newPattern);
        newProbe = this.strUtil().reverse(newProbe);
        StringPattern newMatcher = new StringPattern(newPattern, this.getIgnoreCase());
        newMatcher.setSingleCharWildcard(this.getSingleCharWildcard());
        newMatcher.setMultiCharWildcard(this.getMultiCharWildcard());
        newMatcher.multiCharWildcardMatchesEmptyString(this.multiCharWildcardMatchesEmptyString());
        if (this.hasDigitWildcard()) {
            newMatcher.setDigitWildcardChar(this.digitWildcardChar());
        }
        return newMatcher.matches(newProbe);
    }

    protected boolean charsAreEqual(char probeChar, char patternChar) {
        if (patternChar == this.getSingleCharWildcard()) {
            return true;
        }
        if (this.hasDigitWildcard() && patternChar == this.digitWildcardChar()) {
            return Character.isDigit(probeChar);
        }
        if (this.getIgnoreCase()) {
            return Character.toUpperCase(probeChar) == Character.toUpperCase(patternChar);
        }
        return probeChar == patternChar;
    }

    protected boolean endReached(char character) {
        return character == '\uffff';
    }

    protected boolean endNotReached(char character) {
        return !this.endReached(character);
    }

    protected char getPatternChar(StringExaminer patternIterator, char probeCh) {
        char patternCh = patternIterator.nextChar();
        return patternCh == this.getSingleCharWildcard() ? probeCh : patternCh;
    }

    protected StringExaminer newExaminer(String str) {
        return new StringExaminer(str, this.getIgnoreCase());
    }

    protected String ignoreCaseAsString() {
        return this.getIgnoreCase() ? SWITCH_ON : SWITCH_OFF;
    }

    protected String[] selectOrReject(String[] strings, boolean select) {
        if (strings == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(strings.length);
        int i = 0;
        while (i < strings.length) {
            if (select == this.matches(strings[i])) {
                result.add(strings[i]);
            }
            ++i;
        }
        return this.strUtil().asStrings(result);
    }

    protected String inspectString() {
        StringBuffer buffer = new StringBuffer(50);
        buffer.append(INSPECT_PREFIX);
        buffer.append(this.ignoreCaseAsString());
        buffer.append(INSPECT_SEPARATOR);
        buffer.append(this.getPattern());
        buffer.append(INSPECT_SUFFIX);
        return buffer.toString();
    }

    protected StringUtil strUtil() {
        return StringUtil.current();
    }
}

