/*
 * Decompiled with CFR 0.152.
 */
package org.pf.text;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.pf.text.AStringFilter;
import org.pf.text.StringPattern;
import org.pf.text.StringUtil;

public class StringPatternCollection
extends AStringFilter {
    protected static final String DEFAULT_PATTERN_SEPARATOR = ";";
    private Collection patterns = null;
    private Boolean ignoreCase = null;

    protected Collection getPatterns() {
        return this.patterns;
    }

    protected void setPatterns(Collection newValue) {
        this.patterns = newValue;
    }

    protected Boolean getIgnoreCase() {
        return this.ignoreCase;
    }

    protected void setIgnoreCase(Boolean newValue) {
        this.ignoreCase = newValue;
    }

    public StringPatternCollection() {
        this.reset();
    }

    public StringPatternCollection(String strPattern) {
        this();
        this.add(strPattern);
    }

    public StringPatternCollection(StringPattern pattern) {
        this();
        this.add(pattern);
    }

    public StringPatternCollection(String[] strPatterns) {
        this();
        this.addPatterns(strPatterns);
    }

    public StringPatternCollection(Collection strPatterns) {
        this();
        this.addPatterns(strPatterns);
    }

    public boolean matches(String aString) {
        return this.matchesAny(aString);
    }

    public boolean matchesAny(String probe) {
        if (probe == null) {
            return false;
        }
        Iterator iter = this.getPatterns().iterator();
        while (iter.hasNext()) {
            StringPattern pattern = (StringPattern)iter.next();
            if (!pattern.matches(probe)) continue;
            return true;
        }
        return false;
    }

    public boolean matchesNone(String probe) {
        return !this.matchesAny(probe);
    }

    public String[] select(String[] strings) {
        return this.selectOrReject(strings, true);
    }

    public String[] reject(String[] strings) {
        return this.selectOrReject(strings, false);
    }

    public void reset() {
        this.setPatterns(new ArrayList());
        this.setIgnoreCase(null);
    }

    public void add(StringPattern aPattern) {
        if (aPattern != null && !this.getPatterns().contains(aPattern)) {
            if (this.getIgnoreCase() != null) {
                aPattern.setIgnoreCase(this.getIgnoreCase());
            }
            this.getPatterns().add(aPattern);
        }
    }

    public void addPatterns(String patternList) {
        this.addPatterns(patternList, DEFAULT_PATTERN_SEPARATOR);
    }

    public void addPatterns(String patternList, String separators) {
        if (patternList != null) {
            String[] strPatterns = this.str().substrings(patternList, separators);
            this.addPatterns(strPatterns);
        }
    }

    public void addPatterns(Collection strPatterns) {
        if (strPatterns != null) {
            this.addPatterns(this.str().asStrings(strPatterns));
        }
    }

    public void addPatterns(StringPatternCollection patternCollection) {
        if (patternCollection != null) {
            Iterator iter = patternCollection.getPatterns().iterator();
            while (iter.hasNext()) {
                StringPattern element = (StringPattern)iter.next();
                this.add(element);
            }
        }
    }

    public void addPatterns(String[] patternCollection) {
        if (patternCollection != null) {
            int i = 0;
            while (i < patternCollection.length) {
                this.add(patternCollection[i]);
                ++i;
            }
        }
    }

    public void add(String pattern) {
        if (pattern != null) {
            this.add(this.newPattern(pattern));
        }
    }

    public boolean remove(StringPattern aPattern) {
        boolean removed = false;
        if (aPattern != null) {
            removed = this.getPatterns().remove(aPattern);
        }
        return removed;
    }

    public int size() {
        return this.getPatterns().size();
    }

    public boolean isEmpty() {
        return this.getPatterns().isEmpty();
    }

    public void setIgnoreCase(boolean ignore) {
        Iterator iterator = this.getPatterns().iterator();
        while (iterator.hasNext()) {
            StringPattern pattern = (StringPattern)iterator.next();
            pattern.setIgnoreCase(ignore);
        }
        this.setIgnoreCase(ignore ? Boolean.TRUE : Boolean.FALSE);
    }

    protected StringPattern newPattern(String pattern) {
        StringPattern strPattern = new StringPattern(pattern);
        strPattern.multiCharWildcardMatchesEmptyString(true);
        return strPattern;
    }

    protected String[] selectOrReject(String[] strings, boolean select) {
        if (strings == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(strings.length);
        int i = 0;
        while (i < strings.length) {
            if (select == this.matchesAny(strings[i])) {
                result.add(strings[i]);
            }
            ++i;
        }
        return this.str().asStrings(result);
    }

    protected String getDefaultPatternSeparator() {
        return DEFAULT_PATTERN_SEPARATOR;
    }

    protected StringUtil str() {
        return StringUtil.current();
    }
}

