/*
 * Decompiled with CFR 0.152.
 */
package org.pf.textx;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pf.textx.UnknownVariableException;
import org.pf.textx.VariableResolver;

public class VariableResolverPool
implements VariableResolver {
    private Map pool = null;

    protected Map getPool() {
        return this.pool;
    }

    protected void setPool(Map aValue) {
        this.pool = aValue;
    }

    public VariableResolverPool() {
        this.setPool(this.createNewPool());
    }

    public VariableResolverPool(Map aMap) {
        this.setPool(aMap);
    }

    public Object getValue(String varName) throws UnknownVariableException {
        Object value = null;
        VariableResolver resolver = null;
        resolver = this.findResolverFor(varName);
        if (resolver == null) {
            throw new UnknownVariableException(varName);
        }
        value = resolver.getValue(varName);
        return value;
    }

    public boolean isKnownVariable(String varName) {
        VariableResolver resolver = null;
        resolver = this.findResolverFor(varName);
        return resolver != null;
    }

    public Set knownVariableNames() {
        HashSet names = new HashSet();
        VariableResolver resolver = null;
        Iterator iterator = null;
        iterator = this.getPool().values().iterator();
        while (iterator.hasNext()) {
            resolver = (VariableResolver)iterator.next();
            names.addAll(resolver.knownVariableNames());
        }
        return names;
    }

    public void add(String resolverName, VariableResolver resolver) {
        if (resolverName != null && resolver != null) {
            this.getPool().put(resolverName, resolver);
        }
    }

    public void replace(String resolverName, VariableResolver resolver) {
        this.remove(resolverName);
        this.add(resolverName, resolver);
    }

    public void remove(String resolverName) {
        if (resolverName != null) {
            this.getPool().remove(resolverName);
        }
    }

    public VariableResolver resolverNamed(String resolverName) {
        return (VariableResolver)this.getPool().get(resolverName);
    }

    protected VariableResolver findResolverFor(String varName) {
        VariableResolver resolver = null;
        VariableResolver result = null;
        Iterator iterator = null;
        Map.Entry entry = null;
        iterator = this.getPool().entrySet().iterator();
        while (result == null && iterator.hasNext()) {
            entry = iterator.next();
            resolver = (VariableResolver)entry.getValue();
            if (!resolver.isKnownVariable(varName)) continue;
            result = resolver;
        }
        return result;
    }

    protected Map createNewPool() {
        return new Hashtable();
    }
}

