/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.pf.util.MapEntry;
import org.pf.util.MapWrapper;
import org.pf.util.NamedValue;

public class CaseInsensitiveKeyMap
extends MapWrapper {
    public CaseInsensitiveKeyMap() {
    }

    public CaseInsensitiveKeyMap(int initialCapacity) {
        super(initialCapacity);
    }

    public boolean containsKey(Object key) {
        String name = this.standardizeKey(key);
        if (name == null) {
            return false;
        }
        return this.internalMap().containsKey(name);
    }

    public Object get(Object key) {
        Object value = null;
        String name = this.standardizeKey(key);
        if (name != null) {
            NamedValue namedValue = (NamedValue)this.internalMap().get(name);
            if (namedValue != null) {
                value = namedValue.value();
            }
            return value;
        }
        return null;
    }

    public Object put(Object key, Object value) {
        String name = this.standardizeKey(key);
        if (name != null) {
            NamedValue namedValue = new NamedValue((String)key, value);
            namedValue = this.internalMap().put(name, namedValue);
            if (namedValue == null) {
                return null;
            }
            return namedValue.value();
        }
        return null;
    }

    public void putAll(Map map) {
        Iterator iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public boolean containsValue(Object value) {
        Map.Entry entry = this.findByValue(value);
        return entry != null;
    }

    public Collection values() {
        ArrayList<Object> values = new ArrayList<Object>(this.size());
        Iterator iterator = this.internalMap().values().iterator();
        while (iterator.hasNext()) {
            NamedValue namedValue = (NamedValue)iterator.next();
            values.add(namedValue.value());
        }
        return values;
    }

    public Object remove(Object key) {
        String name = this.standardizeKey(key);
        if (name != null) {
            NamedValue namedValue = (NamedValue)this.internalMap().remove(name);
            if (namedValue == null) {
                return null;
            }
            return namedValue.value();
        }
        return null;
    }

    public Set entrySet() {
        HashSet<MapEntry> entries = new HashSet<MapEntry>(this.size());
        Iterator iterator = this.internalMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            NamedValue namedValue = (NamedValue)entry.getValue();
            MapEntry newEntry = new MapEntry(namedValue.key(), namedValue.value());
            entries.add(newEntry);
        }
        return entries;
    }

    protected String standardizeKey(Object key) {
        if (key instanceof String) {
            return ((String)key).toLowerCase();
        }
        return null;
    }

    protected Map.Entry findByValue(Object value) {
        if (value == null) {
            return null;
        }
        Iterator iterator = this.internalMap().entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            NamedValue namedValue = (NamedValue)entry.getValue();
            if (!value.equals(namedValue.value())) continue;
            return entry;
        }
        return null;
    }
}

