/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.pf.util.NamedText;
import org.pf.util.OrderedMap;
import org.pf.util.OrderedSet;

public class OrderedProperties
extends Properties {
    protected static final int INITIAL_CAPACITY = 50;
    private List elements = null;
    private Map propertyIndex = null;

    protected List getElements() {
        return this.elements;
    }

    protected void setElements(List newValue) {
        this.elements = newValue;
    }

    protected Map getPropertyIndex() {
        return this.propertyIndex;
    }

    protected void setPropertyIndex(Map newValue) {
        this.propertyIndex = newValue;
    }

    public OrderedProperties() {
        this(50);
    }

    public OrderedProperties(int initialCapacity) {
        this.setElements(new ArrayList(initialCapacity));
        this.setPropertyIndex(new HashMap(initialCapacity));
    }

    public String[] getPropertyNames() {
        ArrayList<String> names = new ArrayList<String>(this.size());
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            NamedText property = (NamedText)iter.next();
            if (!this.isValidProperty(property)) continue;
            names.add(property.name());
        }
        return names.toArray(new String[names.size()]);
    }

    public int size() {
        return this.getElements().size();
    }

    public String getProperty(String name) {
        NamedText property = this.findProperty(name);
        if (this.isNullOrDeleted(property)) {
            return null;
        }
        return property.text();
    }

    public Object setProperty(String name, String value) {
        NamedText property = this.findProperty(name);
        if (property == null) {
            this.appendProperty(name, value);
            return null;
        }
        String oldValue = property.text();
        property.text(value);
        return oldValue;
    }

    public boolean deleteProperty(String name) {
        return this.remove(name) != null;
    }

    public Object remove(Object key) {
        if (!(key instanceof String)) {
            return null;
        }
        NamedText property = this.findProperty((String)key);
        if (property == null) {
            return null;
        }
        this.getPropertyIndex().remove(property.name());
        this.getElements().remove(property);
        return property.text();
    }

    public String getProperty(String key, String defaultValue) {
        NamedText property = this.findProperty(key);
        if (property == null) {
            return defaultValue;
        }
        return property.text();
    }

    public void list(PrintStream out) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".list()");
    }

    public void list(PrintWriter out) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".list()");
    }

    public synchronized void load(InputStream inStream) throws IOException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".load()");
    }

    public Enumeration propertyNames() {
        Vector<String> names = new Vector<String>(this.size());
        String[] nameArray = this.getPropertyNames();
        int i = 0;
        while (i < nameArray.length) {
            names.add(nameArray[i]);
            ++i;
        }
        return names.elements();
    }

    public synchronized void save(OutputStream out, String header) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".save()");
    }

    public synchronized void store(OutputStream out, String header) throws IOException {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".store()");
    }

    public synchronized void clear() {
        this.getElements().clear();
        this.getPropertyIndex().clear();
    }

    public synchronized Enumeration keys() {
        return this.propertyNames();
    }

    public Set keySet() {
        OrderedSet keys = new OrderedSet(this.size());
        String[] nameArray = this.getPropertyNames();
        int i = 0;
        while (i < nameArray.length) {
            keys.add(nameArray[i]);
            ++i;
        }
        return keys;
    }

    public Set entrySet() {
        OrderedMap entries = new OrderedMap();
        Iterator iter = this.getElements().iterator();
        while (iter.hasNext()) {
            NamedText element = (NamedText)iter.next();
            if (!this.isValidProperty(element)) continue;
            entries.put(element.name(), element.text());
        }
        return entries.entrySet();
    }

    protected boolean appendProperty(String name, String value) {
        NamedText property = this.newProperty(name, value);
        this.addElement(property);
        return true;
    }

    protected NamedText newProperty(String name, String value) {
        return new NamedText(name, value);
    }

    protected void addElement(NamedText element) {
        Integer index = new Integer(this.size());
        this.getElements().add(element);
        this.registerProperty(element, index);
    }

    protected void registerProperty(NamedText property, Integer index) {
        this.getPropertyIndex().put(property.name(), index);
    }

    protected NamedText findProperty(String key) {
        Integer index = this.indexOfProperty(key);
        if (index == null) {
            return null;
        }
        return this.propertyAt(index);
    }

    protected Integer indexOfProperty(String key) {
        return (Integer)this.getPropertyIndex().get(key);
    }

    protected NamedText propertyAt(Integer index) {
        return this.propertyAt((int)index);
    }

    protected NamedText propertyAt(int index) {
        return (NamedText)this.getElements().get(index);
    }

    protected boolean isNullOrDeleted(NamedText property) {
        return property == null;
    }

    protected boolean isValidProperty(NamedText property) {
        return true;
    }
}

