/*
 * Decompiled with CFR 0.152.
 */
package org.pf.util;

import org.pf.util.TriggerClient;

public class Trigger
implements Runnable {
    private String name = null;
    private TriggerClient client = null;
    private long interval = 300000L;
    private boolean suspended = false;
    private boolean terminated = false;
    static /* synthetic */ Class class$0;

    public String getName() {
        return this.name;
    }

    protected void setName(String newValue) {
        this.name = newValue;
    }

    protected TriggerClient getClient() {
        return this.client;
    }

    protected void setClient(TriggerClient newValue) {
        this.client = newValue;
    }

    protected long getInterval() {
        return this.interval;
    }

    protected void setInterval(long newValue) {
        this.interval = newValue;
    }

    protected boolean getSuspended() {
        return this.suspended;
    }

    protected void setSuspended(boolean newValue) {
        this.suspended = newValue;
    }

    protected boolean getTerminated() {
        return this.terminated;
    }

    protected void setTerminated(boolean newValue) {
        this.terminated = newValue;
    }

    public static Trigger launch(String name, TriggerClient client, long intervalInMs) {
        String invalidArg = null;
        Trigger trigger = null;
        Thread thread = null;
        if (name == null) {
            invalidArg = "name";
        } else if (client == null) {
            invalidArg = "client";
        } else if (intervalInMs <= 0L) {
            invalidArg = "intervalInMs";
        }
        if (invalidArg != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.pf.util.Trigger");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            throw new IllegalArgumentException(String.valueOf(clazz.getName()) + ".launch() -> " + invalidArg);
        }
        trigger = new Trigger(name, client, intervalInMs);
        thread = new Thread(trigger);
        thread.start();
        return trigger;
    }

    protected Trigger(String name, TriggerClient client, long intervalInMs) {
        this.setName(name);
        this.setClient(client);
        this.setInterval(intervalInMs);
    }

    public void terminate() {
        this.setTerminated(true);
    }

    public void run() {
        while (!this.isTerminated()) {
            try {
                Thread.sleep(this.getInterval());
                if (this.isTerminated() || this.isSuspended() || !this.canBeTriggered()) continue;
                this.trigger();
            }
            catch (InterruptedException ex) {
                this.setTerminated(true);
            }
        }
    }

    protected boolean canBeTriggered() {
        return this.getClient().canBeTriggeredBy(this);
    }

    protected void trigger() {
        boolean cont = this.getClient().triggeredBy(this);
        if (!cont) {
            this.setSuspended(true);
        }
    }

    protected boolean isTerminated() {
        return this.getTerminated();
    }

    protected boolean isSuspended() {
        return this.getSuspended();
    }
}

