/*
 * Decompiled with CFR 0.152.
 */
package io.gsonfire.postprocessors;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import io.gsonfire.PostProcessor;
import io.gsonfire.annotations.ExposeMethodResult;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class MethodInvokerPostProcessor<T>
implements PostProcessor<T> {
    private static Map<Class, MappedMethod[]> methodMap = new ConcurrentHashMap<Class, MappedMethod[]>();

    @Override
    public void postDeserialize(T result, JsonElement src, Gson gson) {
    }

    @Override
    public void postSerialize(JsonElement result, T src, Gson gson) {
        if (result.isJsonObject()) {
            JsonObject jsonObject = result.getAsJsonObject();
            for (MappedMethod m : this.getMappedMethods(src.getClass())) {
                try {
                    if (m.conflictResolutionStrategy != ExposeMethodResult.ConflictResolutionStrategy.OVERWRITE && (m.conflictResolutionStrategy != ExposeMethodResult.ConflictResolutionStrategy.SKIP || jsonObject.has(m.fieldName))) continue;
                    Object value = m.method.invoke(src, new Object[0]);
                    jsonObject.add(m.fieldName, gson.toJsonTree(value));
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private synchronized MappedMethod[] getMappedMethods(Class<? super T> clazz) {
        MappedMethod[] methods = methodMap.get(clazz);
        if (methods == null) {
            ArrayList<MappedMethod> methodList = new ArrayList<MappedMethod>();
            for (Method m : this.getAllMethods(clazz)) {
                if (!m.isAnnotationPresent(ExposeMethodResult.class)) continue;
                if (m.getParameterTypes().length > 0) {
                    throw new InvalidParameterException("The methods annotated with ExposeMethodResult should have no arguments");
                }
                ExposeMethodResult exposeMethodResult = m.getAnnotation(ExposeMethodResult.class);
                m.setAccessible(true);
                MappedMethod mm = new MappedMethod();
                mm.method = m;
                mm.fieldName = exposeMethodResult.value();
                mm.conflictResolutionStrategy = exposeMethodResult.conflictResolution();
                methodList.add(mm);
            }
            methods = new MappedMethod[methodList.size()];
            methodList.toArray(methods);
            methodMap.put(clazz, methods);
        }
        return methods;
    }

    private Collection<Method> getAllMethods(Class clazz) {
        HashSet<Method> allMethods = new HashSet<Method>();
        if (clazz == null || clazz == Object.class) {
            return allMethods;
        }
        for (Method method : clazz.getDeclaredMethods()) {
            allMethods.add(method);
        }
        allMethods.addAll(this.getAllMethods(clazz.getSuperclass()));
        for (GenericDeclaration genericDeclaration : clazz.getInterfaces()) {
            allMethods.addAll(this.getAllMethods((Class)genericDeclaration));
        }
        return allMethods;
    }

    private static class MappedMethod {
        public Method method;
        public String fieldName;
        public ExposeMethodResult.ConflictResolutionStrategy conflictResolutionStrategy;

        private MappedMethod() {
        }
    }
}

