/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.io.IOUtils;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.SpaceTypeDescriptorVersionedSerializationUtils;
import com.gigaspaces.persistency.error.SpaceMongoDataSourceException;
import com.gigaspaces.persistency.error.SpaceMongoException;
import com.gigaspaces.persistency.metadata.BatchUnit;
import com.gigaspaces.persistency.metadata.DefaultSpaceDocumentMapper;
import com.gigaspaces.persistency.metadata.IndexBuilder;
import com.gigaspaces.persistency.metadata.SpaceDocumentMapper;
import com.gigaspaces.sync.AddIndexData;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.IntroduceTypeData;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.WriteResult;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.persistency.support.SpaceTypeDescriptorContainer;
import org.openspaces.persistency.support.TypeDescriptorUtils;

public class MongoClientConnector {
    private static final String DOLLAR_SIGN = "__d_s__";
    private static final String TYPE_DESCRIPTOR_FIELD_NAME = "value";
    private static final String METADATA_COLLECTION_NAME = "metadata";
    private static final Log logger = LogFactory.getLog(MongoClientConnector.class);
    private final MongoClient client;
    private final String dbName;
    private final IndexBuilder indexBuilder;
    private static final Map<String, SpaceTypeDescriptorContainer> types = new ConcurrentHashMap<String, SpaceTypeDescriptorContainer>();
    private static final Map<String, SpaceDocumentMapper<DBObject>> mappingCache = new ConcurrentHashMap<String, SpaceDocumentMapper<DBObject>>();

    public MongoClientConnector(MongoClient client, String db) {
        this.client = client;
        this.dbName = db;
        this.indexBuilder = new IndexBuilder(this);
    }

    public void close() throws IOException {
        this.client.close();
    }

    public void introduceType(IntroduceTypeData introduceTypeData) {
        this.introduceType(introduceTypeData.getTypeDescriptor());
    }

    public void introduceType(SpaceTypeDescriptor typeDescriptor) {
        DBCollection m = this.getConnection().getCollection(METADATA_COLLECTION_NAME);
        BasicDBObjectBuilder builder = BasicDBObjectBuilder.start().add("_id", (Object)typeDescriptor.getTypeName());
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(bos);
            IOUtils.writeObject((ObjectOutput)out, (Object)SpaceTypeDescriptorVersionedSerializationUtils.toSerializableForm((SpaceTypeDescriptor)typeDescriptor));
            builder.add(TYPE_DESCRIPTOR_FIELD_NAME, (Object)bos.toByteArray());
            WriteResult wr = m.save(builder.get());
            if (logger.isTraceEnabled()) {
                logger.trace((Object)wr);
            }
            this.indexBuilder.ensureIndexes(typeDescriptor);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new SpaceMongoException("error occurs while serialize and save type descriptor: " + typeDescriptor, e);
        }
    }

    public DB getConnection() {
        return this.client.getDB(this.dbName);
    }

    public DBCollection getCollection(String collectionName) {
        return this.getConnection().getCollection(collectionName.replace("$", DOLLAR_SIGN));
    }

    public void performBatch(DataSyncOperation[] operations) {
        LinkedList<BatchUnit> rows = new LinkedList<BatchUnit>();
        for (DataSyncOperation operation : operations) {
            BatchUnit bu = new BatchUnit();
            this.cacheTypeDescriptor(operation.getTypeDescriptor());
            bu.setSpaceDocument(operation.getDataAsDocument());
            bu.setDataSyncOperationType(operation.getDataSyncOperationType());
            rows.add(bu);
        }
        this.performBatch(rows);
    }

    public void performBatch(List<BatchUnit> rows) {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("MongoClientWrapper.performBatch(" + rows + ")"));
            logger.trace((Object)("Batch size to be performed is " + rows.size()));
        }
        block5: for (BatchUnit row : rows) {
            SpaceDocument spaceDoc = row.getSpaceDocument();
            SpaceTypeDescriptor typeDescriptor = types.get(row.getTypeName()).getTypeDescriptor();
            SpaceDocumentMapper<DBObject> mapper = MongoClientConnector.getMapper(typeDescriptor);
            DBObject obj = mapper.toDBObject(spaceDoc);
            DBCollection col = this.getCollection(row.getTypeName());
            switch (row.getDataSyncOperationType()) {
                case WRITE: 
                case UPDATE: {
                    col.save(obj);
                    continue block5;
                }
                case PARTIAL_UPDATE: {
                    DBObject query = BasicDBObjectBuilder.start().add("_id", obj.get("_id")).get();
                    DBObject update = MongoClientConnector.normalize(obj);
                    col.update(query, update);
                    continue block5;
                }
                case REMOVE: {
                    col.remove(obj);
                    continue block5;
                }
            }
            throw new IllegalStateException("Unsupported data sync operation type: " + row.getDataSyncOperationType());
        }
    }

    public Collection<SpaceTypeDescriptor> loadMetadata() {
        DBCollection metadata = this.getCollection(METADATA_COLLECTION_NAME);
        DBCursor cursor = metadata.find((DBObject)new BasicDBObject());
        while (cursor.hasNext()) {
            DBObject type = cursor.next();
            Object b = type.get(TYPE_DESCRIPTOR_FIELD_NAME);
            this.readMetadata(b);
        }
        return this.getSortedTypes();
    }

    public Collection<SpaceTypeDescriptor> getSortedTypes() {
        return TypeDescriptorUtils.sort(types);
    }

    private void cacheTypeDescriptor(SpaceTypeDescriptor typeDescriptor) {
        if (typeDescriptor == null) {
            throw new IllegalArgumentException("typeDescriptor can not be null");
        }
        if (!types.containsKey(typeDescriptor.getTypeName())) {
            this.introduceType(typeDescriptor);
        }
        types.put(typeDescriptor.getTypeName(), new SpaceTypeDescriptorContainer(typeDescriptor));
    }

    private void readMetadata(Object b) {
        try {
            ClassLoaderAwareInputStream in = new ClassLoaderAwareInputStream(new ByteArrayInputStream((byte[])b));
            Serializable typeDescWrapper = (Serializable)IOUtils.readObject((ObjectInput)in);
            SpaceTypeDescriptor typeDescriptor = SpaceTypeDescriptorVersionedSerializationUtils.fromSerializableForm((Serializable)typeDescWrapper);
            this.indexBuilder.ensureIndexes(typeDescriptor);
            this.cacheTypeDescriptor(typeDescriptor);
        }
        catch (ClassNotFoundException e) {
            logger.error((Object)e);
            throw new SpaceMongoDataSourceException("Failed to deserialize: " + b, e);
        }
        catch (IOException e) {
            logger.error((Object)e);
            throw new SpaceMongoDataSourceException("Failed to deserialize: " + b, e);
        }
    }

    public void ensureIndexes(AddIndexData addIndexData) {
        this.indexBuilder.ensureIndexes(addIndexData);
    }

    private static SpaceDocumentMapper<DBObject> getMapper(SpaceTypeDescriptor typeDescriptor) {
        DefaultSpaceDocumentMapper mapper = mappingCache.get(typeDescriptor.getTypeName());
        if (mapper == null) {
            mapper = new DefaultSpaceDocumentMapper(typeDescriptor);
            mappingCache.put(typeDescriptor.getTypeName(), mapper);
        }
        return mapper;
    }

    private static DBObject normalize(DBObject obj) {
        BasicDBObjectBuilder builder = BasicDBObjectBuilder.start();
        Iterator iterator = obj.keySet().iterator();
        builder.push("$set");
        while (iterator.hasNext()) {
            Object value;
            String key = (String)iterator.next();
            if ("_id".equals(key) || (value = obj.get(key)) == null) continue;
            builder.add(key, value);
        }
        return builder.get();
    }

    private static long waitFor(List<Future<? extends Number>> replies) {
        long total = 0L;
        for (Future<? extends Number> future : replies) {
            try {
                total += future.get().longValue();
            }
            catch (InterruptedException e) {
                throw new SpaceMongoException("Number of async operations: " + replies.size(), e);
            }
            catch (ExecutionException e) {
                throw new SpaceMongoException("Number of async operations: " + replies.size(), e);
            }
        }
        return total;
    }

    private static class ClassLoaderAwareInputStream
    extends ObjectInputStream {
        private ClassLoaderAwareInputStream(InputStream in) throws IOException {
            super(in);
        }

        public Class resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
            ClassLoader currentTccl = null;
            try {
                currentTccl = Thread.currentThread().getContextClassLoader();
                return currentTccl.loadClass(desc.getName());
            }
            catch (Exception exception) {
                return super.resolveClass(desc);
            }
        }
    }
}

