/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataIteratorAdapter;
import com.gigaspaces.datasource.DataSourceIdQuery;
import com.gigaspaces.datasource.DataSourceIdsQuery;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.datasource.SpaceDataSource;
import com.gigaspaces.metadata.SpacePropertyDescriptor;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.persistency.MongoClientConnector;
import com.gigaspaces.persistency.datasource.DefaultMongoDataIterator;
import com.gigaspaces.persistency.datasource.MongoInitialDataLoadIterator;
import com.gigaspaces.persistency.datasource.MongoSqlQueryDataIterator;
import com.gigaspaces.persistency.metadata.DefaultSpaceDocumentMapper;
import com.mongodb.BasicDBObject;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.core.cluster.ClusterInfo;

public class MongoSpaceDataSource
extends SpaceDataSource {
    private static final Log logger = LogFactory.getLog(MongoSpaceDataSource.class);
    private final MongoClientConnector mongoClient;
    protected ClusterInfo clusterInfo;

    public MongoSpaceDataSource(MongoClientConnector mongoClient, ClusterInfo clusterInfo) {
        if (mongoClient == null) {
            throw new IllegalArgumentException("Argument cannot be null - mongoClient");
        }
        this.mongoClient = mongoClient;
        this.clusterInfo = clusterInfo;
    }

    public void close() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"MongoSpaceDataSource.close()");
        }
        this.mongoClient.close();
    }

    public boolean supportsInheritance() {
        return false;
    }

    public DataIterator<SpaceTypeDescriptor> initialMetadataLoad() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"MongoSpaceDataSource.initialMetadataLoad()");
        }
        Collection<SpaceTypeDescriptor> sortedCollection = this.mongoClient.loadMetadata();
        return new DataIteratorAdapter(sortedCollection.iterator());
    }

    public DataIterator<Object> initialDataLoad() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"MongoSpaceDataSource.initialDataLoad()");
        }
        return new MongoInitialDataLoadIterator(this, this.mongoClient);
    }

    public DBObject getInitialQuery(SpaceTypeDescriptor typeDescriptor) {
        SpacePropertyDescriptor routingPropDesc;
        BasicDBObject query = new BasicDBObject();
        String routingPropertyName = typeDescriptor.getRoutingPropertyName();
        if (this.clusterInfo != null && this.clusterInfo.getNumberOfInstances() > 1 && routingPropertyName != null && Integer.class.isAssignableFrom((routingPropDesc = typeDescriptor.getFixedProperty(routingPropertyName)).getType())) {
            ArrayList<Integer> l = new ArrayList<Integer>();
            l.add(this.clusterInfo.getNumberOfInstances());
            l.add(this.clusterInfo.getInstanceId() - 1);
            query.put(routingPropertyName, (Object)new BasicDBObject("$mod", l));
        }
        return query;
    }

    public DataIterator<Object> getDataIterator(DataSourceQuery query) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MongoSpaceDataSource.getDataIterator(" + query + ")"));
        }
        return new MongoSqlQueryDataIterator(this.mongoClient, query);
    }

    public Object getById(DataSourceIdQuery idQuery) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MongoSpaceDataSource.getById(" + idQuery + ")"));
        }
        DefaultSpaceDocumentMapper mapper = new DefaultSpaceDocumentMapper(idQuery.getTypeDescriptor());
        BasicDBObjectBuilder documentBuilder = BasicDBObjectBuilder.start().add("_id", mapper.toObject(idQuery.getId()));
        DBCollection mongoCollection = this.mongoClient.getCollection(idQuery.getTypeDescriptor().getTypeName());
        DBObject result = mongoCollection.findOne(documentBuilder.get());
        return mapper.toDocument(result);
    }

    public DataIterator<Object> getDataIteratorByIds(DataSourceIdsQuery idsQuery) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MongoSpaceDataSource.getDataIteratorByIds(" + idsQuery + ")"));
        }
        DBObject[] ors = new DBObject[idsQuery.getIds().length];
        for (int i = 0; i < ors.length; ++i) {
            ors[i] = BasicDBObjectBuilder.start().add("_id", idsQuery.getIds()[i]).get();
        }
        DBObject document = QueryBuilder.start().or(ors).get();
        DBCollection mongoCollection = this.mongoClient.getCollection(idsQuery.getTypeDescriptor().getTypeName());
        DBCursor results = mongoCollection.find(document);
        return new DefaultMongoDataIterator(results, idsQuery.getTypeDescriptor());
    }
}

