/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency;

import com.gigaspaces.persistency.MongoClientConnector;
import com.gigaspaces.sync.AddIndexData;
import com.gigaspaces.sync.DataSyncOperation;
import com.gigaspaces.sync.IntroduceTypeData;
import com.gigaspaces.sync.OperationsBatchData;
import com.gigaspaces.sync.SpaceSynchronizationEndpoint;
import com.gigaspaces.sync.TransactionData;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MongoSpaceSynchronizationEndpoint
extends SpaceSynchronizationEndpoint {
    private static final Log logger = LogFactory.getLog(MongoSpaceSynchronizationEndpoint.class);
    private final MongoClientConnector client;

    public MongoSpaceSynchronizationEndpoint(MongoClientConnector client) {
        if (client == null) {
            throw new IllegalArgumentException("mongo client can not be null.");
        }
        this.client = client;
    }

    public void close() throws IOException {
        if (logger.isDebugEnabled()) {
            logger.trace((Object)"MongoSpaceSynchronizationEndpoint.close()");
        }
        this.client.close();
    }

    public void onIntroduceType(IntroduceTypeData introduceTypeData) {
        if (logger.isDebugEnabled()) {
            logger.trace((Object)("MongoSpaceSynchronizationEndpoint.onIntroduceType(" + introduceTypeData + ")"));
        }
        this.client.introduceType(introduceTypeData);
    }

    public void onAddIndex(AddIndexData addIndexData) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("MongoSpaceSynchronizationEndpoint.onAddIndex(" + addIndexData + ")"));
        }
        this.client.ensureIndexes(addIndexData);
    }

    public void onOperationsBatchSynchronization(OperationsBatchData batchData) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"MongoSpaceSynchronizationEndpoint.onOperationsBatchSynchronization()");
        }
        this.synchronize(batchData.getBatchDataItems());
    }

    public void onTransactionSynchronization(TransactionData transactionData) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"MongoSpaceSynchronizationEndpoint.onTransactionSynchronization()");
        }
        this.synchronize(transactionData.getTransactionParticipantDataItems());
    }

    private void synchronize(DataSyncOperation[] operations) {
        if (logger.isDebugEnabled()) {
            logger.trace((Object)"MongoSpaceSynchronizationEndpoint.doSynchronization()");
        }
        this.client.performBatch(operations);
    }
}

