/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency.archive;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.persistency.MongoClientConnector;
import com.gigaspaces.persistency.MongoClientConnectorConfigurer;
import com.gigaspaces.persistency.archive.SpaceMongoArchiveOperationHandlerException;
import com.gigaspaces.persistency.metadata.BatchUnit;
import com.gigaspaces.sync.DataSyncOperationType;
import com.mongodb.MongoClient;
import java.io.IOException;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.openspaces.archive.ArchiveOperationHandler;
import org.openspaces.core.GigaSpace;
import org.springframework.beans.factory.annotation.Required;

public class MongoArchiveOperationHandler
implements ArchiveOperationHandler {
    private static final Log logger = LogFactory.getLog(MongoArchiveOperationHandler.class);
    private GigaSpace gigaSpace;
    private MongoClientConnector connector;
    private MongoClient client;
    private String db;

    @Required
    public void setGigaSpace(GigaSpace gigaSpace) {
        this.gigaSpace = gigaSpace;
    }

    public void archive(Object ... objects) {
        ArrayList<BatchUnit> rows = new ArrayList<BatchUnit>(objects.length);
        for (Object object : objects) {
            if (!(object instanceof SpaceDocument)) {
                throw new SpaceMongoArchiveOperationHandlerException(object.getClass() + " is not supported since it is not a " + SpaceDocument.class.getName());
            }
            BatchUnit batchUnit = new BatchUnit();
            batchUnit.setSpaceDocument((SpaceDocument)object);
            ((SpaceDocument)object).getTypeName();
            batchUnit.setDataSyncOperationType(DataSyncOperationType.WRITE);
            rows.add(batchUnit);
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Writing to mongo " + rows.size() + " objects"));
        }
        this.connector.performBatch(rows);
    }

    public boolean supportsBatchArchiving() {
        return true;
    }

    @PostConstruct
    public void afterPropertiesSet() {
        if (this.gigaSpace == null) {
            throw new IllegalArgumentException("gigaSpace cannot be null");
        }
        this.createMongoClient();
    }

    private void createMongoClient() {
        this.connector = new MongoClientConnectorConfigurer().client(this.client).db(this.db).create();
    }

    public GigaSpace getGigaSpace() {
        return this.gigaSpace;
    }

    @Required
    public void setDb(String db) {
        this.db = db;
    }

    @Required
    public void setConfig(MongoClient client) {
        this.client = client;
    }

    @PreDestroy
    public void destroy() {
        if (this.connector != null) {
            try {
                this.connector.close();
            }
            catch (IOException e) {
                throw new SpaceMongoArchiveOperationHandlerException("can not close mongo client", e);
            }
        }
    }

    public MongoClient getConfig() {
        return this.client;
    }
}

