/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency.datasource;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.persistency.metadata.DefaultSpaceDocumentMapper;
import com.gigaspaces.persistency.metadata.SpaceDocumentMapper;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;

public class DefaultMongoDataIterator
implements DataIterator<Object> {
    private DBCursor iterator;
    private SpaceDocumentMapper<DBObject> mapper;

    public DefaultMongoDataIterator(DBCursor iterator, SpaceTypeDescriptor typeDescriptor) {
        if (iterator == null) {
            throw new IllegalArgumentException("iterator can not be null");
        }
        if (typeDescriptor == null) {
            throw new IllegalArgumentException("typeDescriptor can not be null");
        }
        this.iterator = iterator;
        this.mapper = new DefaultSpaceDocumentMapper(typeDescriptor);
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public Object next() {
        return this.mapper.toDocument(this.iterator.next());
    }

    public void remove() {
        this.iterator.remove();
    }

    public void close() {
        this.iterator.close();
    }
}

