/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency.datasource;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.persistency.MongoClientConnector;
import com.gigaspaces.persistency.MongoSpaceDataSource;
import com.gigaspaces.persistency.metadata.DefaultSpaceDocumentMapper;
import com.gigaspaces.persistency.metadata.SpaceDocumentMapper;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Iterator;

public class MongoInitialDataLoadIterator
implements DataIterator<Object> {
    private DBCursor currentCursor;
    private final MongoClientConnector mongoClient;
    private final Iterator<SpaceTypeDescriptor> types;
    private SpaceDocumentMapper<DBObject> pojoMapper;
    private final MongoSpaceDataSource mongoSpaceDataSource;

    public MongoInitialDataLoadIterator(MongoSpaceDataSource mongoSpaceDataSource, MongoClientConnector client) {
        this.mongoSpaceDataSource = mongoSpaceDataSource;
        if (client == null) {
            throw new IllegalArgumentException("mongo client can not be null");
        }
        this.mongoClient = client;
        this.types = client.getSortedTypes().iterator();
        this.currentCursor = this.nextDataIterator();
    }

    public void close() {
        if (this.currentCursor != null) {
            this.currentCursor.close();
        }
    }

    public boolean hasNext() {
        while (this.currentCursor != null && !this.currentCursor.hasNext()) {
            this.currentCursor = this.nextDataIterator();
        }
        return this.currentCursor != null;
    }

    public Object next() {
        return this.pojoMapper.toDocument(this.currentCursor.next());
    }

    public void remove() {
        this.currentCursor.remove();
    }

    private DBCursor nextDataIterator() {
        if (!this.types.hasNext()) {
            return null;
        }
        SpaceTypeDescriptor typeDescriptor = this.types.next();
        DBObject query = this.mongoSpaceDataSource.getInitialQuery(typeDescriptor);
        this.pojoMapper = new DefaultSpaceDocumentMapper(typeDescriptor);
        return this.mongoClient.getCollection(typeDescriptor.getTypeName()).find(query);
    }
}

