/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency.datasource;

import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.persistency.metadata.DefaultSpaceDocumentMapper;
import com.gigaspaces.persistency.metadata.SpaceDocumentMapper;
import com.gigaspaces.persistency.parser.SQL2MongoBaseVisitor;
import com.gigaspaces.persistency.parser.SQL2MongoLexer;
import com.gigaspaces.persistency.parser.SQL2MongoParser;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;

public class MongoQueryFactory {
    private static final String LIKE = "like()";
    private static final String RLIKE = "rlike()";
    private static final String PARAM_PLACEHOLDER = "'%{}'";
    private static final Map<SpaceTypeDescriptor, Map<String, String>> cachedQuery = new ConcurrentHashMap<SpaceTypeDescriptor, Map<String, String>>();

    public static BasicDBObjectBuilder create(DataSourceQuery sql) {
        String query;
        String parsedQuery;
        Map<String, String> cache = cachedQuery.get(sql.getTypeDescriptor());
        if (cache == null) {
            cache = new HashMap<String, String>();
            cachedQuery.put(sql.getTypeDescriptor(), cache);
        }
        if ((parsedQuery = cache.get(query = sql.getAsSQLQuery().getQuery())) == null) {
            parsedQuery = MongoQueryFactory.parse(query);
            cache.put(query, parsedQuery);
        }
        BasicDBObjectBuilder queryResult = MongoQueryFactory.bind(parsedQuery, sql.getAsSQLQuery().getQueryParameters(), sql.getTypeDescriptor());
        MongoQueryFactory.replaceIdProperty(queryResult, sql.getTypeDescriptor());
        return queryResult;
    }

    private static void replaceIdProperty(BasicDBObjectBuilder qResult, SpaceTypeDescriptor typeDescriptor) {
        DBObject q = qResult.get();
        if (q.containsField(typeDescriptor.getIdPropertyName())) {
            Object value = q.get(typeDescriptor.getIdPropertyName());
            q.removeField(typeDescriptor.getIdPropertyName());
            q.put("_id", value);
            BasicDBObjectBuilder.start((Map)q.toMap());
        }
    }

    private static String parse(String sql) {
        ANTLRInputStream charstream = new ANTLRInputStream(sql);
        SQL2MongoLexer lexer = new SQL2MongoLexer((CharStream)charstream);
        CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
        SQL2MongoParser parser = new SQL2MongoParser((TokenStream)tokenStream);
        SQL2MongoBaseVisitor visitor = new SQL2MongoBaseVisitor();
        parser.parse().accept(visitor);
        return visitor.getQuery().toString();
    }

    public static BasicDBObjectBuilder bind(String parsedQuery, Object[] parameters, SpaceTypeDescriptor spaceTypeDescriptor) {
        DefaultSpaceDocumentMapper mapper = new DefaultSpaceDocumentMapper(spaceTypeDescriptor);
        DBObject obj = (DBObject)JSON.parse((String)parsedQuery);
        BasicDBObjectBuilder query = BasicDBObjectBuilder.start((Map)obj.toMap());
        if (parameters != null) {
            query = MongoQueryFactory.replaceParameters(parameters, mapper, query, 0);
        }
        return query;
    }

    private static BasicDBObjectBuilder replaceParameters(Object[] parameters, SpaceDocumentMapper<DBObject> mapper, BasicDBObjectBuilder builder, Integer index) {
        BasicDBObjectBuilder newBuilder = BasicDBObjectBuilder.start();
        DBObject document = builder.get();
        for (String field : document.keySet()) {
            Object p;
            Integer n;
            Integer n2;
            Object ph = document.get(field);
            if (index >= parameters.length) {
                return builder;
            }
            if (ph instanceof String) {
                if (!PARAM_PLACEHOLDER.equals(ph)) continue;
                n2 = index;
                n = index = Integer.valueOf(index + 1);
                p = mapper.toObject(parameters[n2]);
                if (p instanceof DBObject && "CUSTOM_BINARY".equals(((DBObject)p).get("__type__"))) {
                    newBuilder.add(field + "." + "hash", ((DBObject)p).get("hash"));
                    continue;
                }
                newBuilder.add(field, p);
                continue;
            }
            if (ph instanceof Pattern) {
                p = (Pattern)ph;
                if (LIKE.equalsIgnoreCase(((Pattern)p).pattern())) {
                    n2 = index;
                    n = index = Integer.valueOf(index + 1);
                    newBuilder.add(field, (Object)MongoQueryFactory.convertLikeExpression((String)parameters[n2]));
                    continue;
                }
                if (!RLIKE.equalsIgnoreCase(((Pattern)p).pattern())) continue;
                n2 = index;
                n = index = Integer.valueOf(index + 1);
                newBuilder.add(field, (Object)Pattern.compile((String)parameters[n2], 2));
                continue;
            }
            DBObject element = (DBObject)ph;
            Object p2 = mapper.toObject(parameters[index]);
            if (p2 instanceof DBObject) {
                String t = (String)((DBObject)p2).get("__type__");
                String op = (String)element.keySet().iterator().next();
                if ("CUSTOM_BINARY".equals(t) && !op.equals("$ne")) {
                    return newBuilder;
                }
            }
            BasicDBObjectBuilder doc = MongoQueryFactory.replaceParameters(parameters, mapper, BasicDBObjectBuilder.start((Map)element.toMap()), index);
            newBuilder.add(field, (Object)doc.get());
        }
        return newBuilder;
    }

    private static Pattern convertLikeExpression(String val) {
        if (val != null && !val.isEmpty()) {
            if (val.charAt(0) == '\'') {
                val = val.substring(1);
            }
            if (val.charAt(val.length() - 1) == '\'') {
                val = val.substring(0, val.length() - 1);
            }
            val = val.charAt(0) != '%' ? "^" + val : val.substring(1);
            val = val.charAt(val.length() - 1) != '%' ? val + "$" : val.substring(0, val.length() - 1);
            val = val.replaceAll("%", ".*");
            val = val.replace('_', '.');
            return Pattern.compile(val);
        }
        return Pattern.compile("");
    }
}

