/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency.datasource;

import com.gigaspaces.datasource.DataIterator;
import com.gigaspaces.datasource.DataSourceQuery;
import com.gigaspaces.persistency.MongoClientConnector;
import com.gigaspaces.persistency.datasource.MongoQueryFactory;
import com.gigaspaces.persistency.error.UnSupportedQueryException;
import com.gigaspaces.persistency.metadata.DefaultSpaceDocumentMapper;
import com.gigaspaces.persistency.metadata.SpaceDocumentMapper;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MongoSqlQueryDataIterator
implements DataIterator<Object> {
    private static final Log logger = LogFactory.getLog(MongoSqlQueryDataIterator.class);
    private final MongoClientConnector client;
    private final DataSourceQuery query;
    private final SpaceDocumentMapper<DBObject> pojoMapper;
    private DBCursor cursor;

    public MongoSqlQueryDataIterator(MongoClientConnector client, DataSourceQuery query) {
        if (client == null) {
            throw new IllegalArgumentException("Argument cannot be null - client");
        }
        if (query == null) {
            throw new IllegalArgumentException("Argument cannot be null - query");
        }
        if (!query.supportsAsSQLQuery() && !query.supportsTemplateAsDocument()) {
            throw new UnSupportedQueryException("not sql query");
        }
        this.client = client;
        this.query = query;
        this.pojoMapper = new DefaultSpaceDocumentMapper(query.getTypeDescriptor());
    }

    public boolean hasNext() {
        if (this.cursor == null) {
            this.init();
        }
        return this.cursor.hasNext();
    }

    public Object next() {
        return this.pojoMapper.toDocument(this.cursor.next());
    }

    private void init() {
        DBCollection collection = this.client.getCollection(this.query.getTypeDescriptor().getTypeName());
        BasicDBObjectBuilder q = BasicDBObjectBuilder.start();
        logger.debug((Object)this.query);
        if (this.query.supportsAsSQLQuery()) {
            q = MongoQueryFactory.create(this.query);
        } else if (this.query.supportsTemplateAsDocument()) {
            Map m = new DefaultSpaceDocumentMapper(this.query.getTypeDescriptor()).toDBObject(this.query.getTemplateAsDocument()).toMap();
            q = BasicDBObjectBuilder.start((Map)m);
        }
        this.cursor = collection.find(q.get());
    }

    public void remove() {
        if (this.cursor != null) {
            this.cursor.remove();
        }
    }

    public void close() {
        if (this.cursor != null) {
            this.cursor.close();
        }
    }
}

