/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency.metadata;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.reflection.ISetterMethod;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.persistency.error.SpaceMongoException;
import com.gigaspaces.persistency.metadata.MongoDocumentObjectConverter;
import com.gigaspaces.persistency.metadata.PojoRepository;
import com.gigaspaces.persistency.metadata.SpaceDocumentMapper;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bson.types.ObjectId;

public class DefaultSpaceDocumentMapper
implements SpaceDocumentMapper<DBObject> {
    private static final byte TYPE_CHAR = -128;
    private static final byte TYPE_BYTE = -127;
    private static final byte TYPE_STRING = -126;
    private static final byte TYPE_BOOLEAN = -125;
    private static final byte TYPE_INT = -124;
    private static final byte TYPE_LONG = -123;
    private static final byte TYPE_FLOAT = -122;
    private static final byte TYPE_DOUBLE = -121;
    private static final byte TYPE_SHORT = -120;
    private static final byte TYPE_UUID = -119;
    private static final byte TYPE_DATE = -118;
    private static final byte TYPE_BIGINT = -117;
    private static final byte TYPE_BIGDECIMAL = -116;
    private static final byte TYPE_BYTEARRAY = -115;
    private static final byte TYPE_ARRAY = 126;
    private static final byte TYPE_COLLECTION = 125;
    private static final byte TYPE_MAP = 124;
    private static final byte TYPE_ENUM = 123;
    private static final byte TYPE_OBJECTID = 122;
    private static final byte TYPE_OBJECT = 127;
    private static final Map<Class<?>, Byte> typeCodes = new HashMap();
    private final PojoRepository repository = new PojoRepository();
    private final SpaceTypeDescriptor spaceTypeDescriptor;

    public DefaultSpaceDocumentMapper(SpaceTypeDescriptor spaceTypeDescriptor) {
        this.spaceTypeDescriptor = spaceTypeDescriptor;
    }

    private byte type(Class c) {
        Byte type = typeCodes.get(c);
        if (type == null) {
            type = c.isEnum() ? Byte.valueOf((byte)123) : (c.isArray() ? Byte.valueOf((byte)126) : (Collection.class.isAssignableFrom(c) ? Byte.valueOf((byte)125) : (Map.class.isAssignableFrom(c) ? Byte.valueOf((byte)124) : Byte.valueOf((byte)127))));
        }
        return type;
    }

    private byte bsonType(Object value) {
        Byte type = typeCodes.get(value.getClass());
        if (type == null) {
            type = BasicDBList.class.isInstance(value) ? Byte.valueOf((byte)126) : Byte.valueOf((byte)127);
        }
        return type;
    }

    @Override
    public Object toDocument(DBObject bson) {
        if (bson == null) {
            return null;
        }
        String type = (String)bson.get("__type__");
        if (this.isDocument(type)) {
            return this.toSpaceDocument(bson);
        }
        return this.toPojo(bson);
    }

    private Object toPojo(DBObject bson) {
        String className = (String)bson.get("__type__");
        try {
            Class<?> type = this.getClassFor(className);
            Object pojo = this.repository.getConstructor(this.getClassFor(className)).newInstance();
            for (String property : bson.keySet()) {
                if ("__type__".equals(property)) continue;
                Object value = bson.get(property);
                boolean isArray = false;
                if (value instanceof BasicDBList) {
                    isArray = true;
                }
                if (value == null) continue;
                if ("_id".equals(property)) {
                    property = this.spaceTypeDescriptor.getIdPropertyName();
                }
                ISetterMethod<Object> setter = this.repository.getSetter(type, property);
                Object val = isArray ? this.toExtractArray((BasicDBList)value, setter.getParameterTypes()[0]) : this.fromDBObject(value);
                if (this.type(setter.getParameterTypes()[0]) == -120) {
                    val = ((Integer)val).shortValue();
                }
                setter.set(pojo, val);
            }
            return pojo;
        }
        catch (InvocationTargetException e) {
            throw new SpaceMongoException("can not invoke constructor or method: " + bson, e);
        }
        catch (InstantiationException e) {
            throw new SpaceMongoException("Could not find default constructor for: " + bson, e);
        }
        catch (IllegalAccessException e) {
            throw new SpaceMongoException("can not access constructor or method: " + bson, e);
        }
    }

    private Object toSpaceDocument(DBObject bson) {
        SpaceDocument document = new SpaceDocument((String)bson.get("__type__"));
        for (String property : bson.keySet()) {
            Object value;
            if ("__type__".equals(property) || (value = bson.get(property)) == null) continue;
            if ("_id".equals(property)) {
                property = this.spaceTypeDescriptor.getIdPropertyName();
            }
            document.setProperty(property, this.fromDBObject(value));
        }
        return document;
    }

    private boolean isDocument(String className) {
        try {
            Class.forName(className);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    @Override
    public Object fromDBObject(Object value) {
        if (value == null) {
            return null;
        }
        switch (this.bsonType(value)) {
            case 122: {
                return null;
            }
            case 126: {
                return this.toExactArray((BasicDBList)value);
            }
            case 127: {
                return this.toExactObject(value);
            }
        }
        return value;
    }

    private Object toExactObject(Object value) {
        DBObject bson = (DBObject)value;
        if (bson.containsField("__type__") && bson.containsField("__value__")) {
            String t = (String)bson.get("__type__");
            if ("CUSTOM_BINARY".equals(t)) {
                Object result = this.deserializeObject(bson);
                return result;
            }
            try {
                Class<?> type = Class.forName(t);
                if (type.isEnum()) {
                    return Enum.valueOf(type, (String)bson.get("__value__"));
                }
                return this.fromSpecialType((DBObject)value);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.toDocument(bson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object deserializeObject(DBObject bson) {
        Object result = null;
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream((byte[])bson.get("__value__"));
            ObjectInputStream in = new ObjectInputStream(bis);
            try {
                result = in.readObject();
            }
            finally {
                in.close();
                bis.close();
            }
        }
        catch (IOException e1) {
            throw new SpaceMongoException("can not deserialize object", e1);
        }
        catch (ClassNotFoundException e) {
            throw new SpaceMongoException("can not deserialize object", e);
        }
        return result;
    }

    private Object toExactArray(BasicDBList value) {
        if (value.size() < 1) {
            throw new IllegalStateException("Illegal BSON array size: " + value.size() + ", size must be at lest 1");
        }
        Class<?> type = this.getClassFor((String)value.get(0));
        return this.toExtractArray(value, type);
    }

    private Object toExtractArray(BasicDBList value, Class<?> type) {
        if (type.isArray()) {
            return this.toArray(type, value);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return this.toCollection(type, value);
        }
        if (Map.class.isAssignableFrom(type)) {
            return this.toMap(type, value);
        }
        throw new SpaceMongoException("invalid Array/Collection/Map type: " + type.getName());
    }

    private Map toMap(Class<?> type, BasicDBList value) {
        try {
            Map map = !type.isInterface() ? (Map)this.repository.getConstructor(type).newInstance() : (Map)this.repository.getConstructor(this.getClassFor((String)value.get(0))).newInstance();
            for (int i = 1; i < value.size(); i += 2) {
                Object key = this.fromDBObject(value.get(i));
                Object val = this.fromDBObject(value.get(i + 1));
                map.put(key, val);
            }
            return map;
        }
        catch (InvocationTargetException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
        catch (InstantiationException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
    }

    private Object toArray(Class<?> type, BasicDBList value) {
        int length = value.size() - 1;
        Object array = Array.newInstance(type.getComponentType(), length);
        for (int i = 1; i < length + 1; ++i) {
            Object v = this.fromDBObject(value.get(i));
            if (SpaceDocument.class.isAssignableFrom(type.getComponentType())) {
                v = MongoDocumentObjectConverter.instance().toDocumentIfNeeded(v, SpaceDocumentSupport.CONVERT);
            }
            if (this.type(type.getComponentType()) == -120) {
                v = ((Integer)v).shortValue();
            }
            Array.set(array, i - 1, v);
        }
        return array;
    }

    private Collection toCollection(Class<?> type, BasicDBList value) {
        try {
            Collection collection = !type.isInterface() ? (Collection)this.repository.getConstructor(type).newInstance() : (Collection)this.repository.getConstructor(this.getClassFor((String)value.get(0))).newInstance();
            for (int i = 1; i < value.size(); ++i) {
                collection.add(this.fromDBObject(value.get(i)));
            }
            return collection;
        }
        catch (InvocationTargetException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
        catch (InstantiationException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
    }

    public Class<?> getClassFor(String type) {
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new SpaceMongoException("Could not resolve type for type: " + type, e);
        }
    }

    @Override
    public DBObject toDBObject(Object document) {
        if (document == null) {
            return null;
        }
        if (document instanceof SpaceDocument) {
            return this.toDBObjectDocument((SpaceDocument)document);
        }
        return this.toDBObjectPojo(document);
    }

    private DBObject toDBObjectDocument(SpaceDocument document) {
        BasicDBObjectBuilder bson = BasicDBObjectBuilder.start();
        Set keys = document.getProperties().keySet();
        bson.add("__type__", (Object)document.getTypeName());
        for (String property : keys) {
            Object value = document.getProperty(property);
            if (value == null) continue;
            if (this.spaceTypeDescriptor.getIdPropertyName().equals(property)) {
                property = "_id";
            }
            bson.add(property, this.toObject(value));
        }
        return bson.get();
    }

    private DBObject toDBObjectPojo(Object pojo) {
        BasicDBObjectBuilder bson = BasicDBObjectBuilder.start();
        Map<String, Method> getters = this.repository.getGetters(pojo.getClass());
        Class<?> type = pojo.getClass();
        bson.add("__type__", (Object)type.getName());
        for (String property : getters.keySet()) {
            Object value = null;
            try {
                value = this.repository.getGetter(type, property).get(pojo);
                if (value == null) continue;
                if (this.spaceTypeDescriptor.getIdPropertyName().equals(property)) {
                    property = "_id";
                }
                bson.add(property, this.toObject(value));
            }
            catch (IllegalArgumentException e) {
                throw new SpaceMongoException("Argument is: " + value, e);
            }
            catch (IllegalAccessException e) {
                throw new SpaceMongoException("Can not access method", e);
            }
            catch (InvocationTargetException e) {
                throw new SpaceMongoException("Can not invoke method", e);
            }
        }
        return bson.get();
    }

    @Override
    public Object toObject(Object property) {
        if (property == null) {
            return null;
        }
        switch (this.type(property.getClass())) {
            case -128: 
            case -127: 
            case -122: 
            case -117: 
            case -116: {
                return this.toSpecialType(property);
            }
            case 127: {
                if (property instanceof SpaceDocument) {
                    return this.toDBObject((SpaceDocument)property);
                }
                if (property instanceof Class) {
                    return this.toSpecialType(property);
                }
                if (property instanceof Locale) {
                    return this.toSpecialType(property);
                }
                if (property instanceof URI) {
                    return this.toSpecialType(property);
                }
                if (property instanceof Timestamp) {
                    return this.toSpecialType(property);
                }
                if (!(property instanceof Serializable)) {
                    return this.toDBObject(property);
                }
                byte[] result = this.serializeObject(property);
                BasicDBObjectBuilder blob = BasicDBObjectBuilder.start();
                blob.add("__type__", (Object)"CUSTOM_BINARY");
                blob.add("__value__", (Object)result);
                blob.add("hash", (Object)Arrays.hashCode(result));
                return blob.get();
            }
            case 123: {
                return this.toEnum(property);
            }
            case 126: {
                return this.toArray(property);
            }
            case 125: {
                return this.toCollection(property);
            }
            case 124: {
                return this.toMap(property);
            }
        }
        return property;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] serializeObject(Object property) {
        byte[] result;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ObjectOutputStream output = new ObjectOutputStream(bos);
            try {
                output.writeObject(property);
                result = bos.toByteArray();
            }
            finally {
                output.close();
                bos.close();
            }
        }
        catch (IOException e) {
            throw new SpaceMongoException("can not serialize object of class " + property.getClass().getName());
        }
        return result;
    }

    private Object toEnum(Object property) {
        BasicDBObjectBuilder document = BasicDBObjectBuilder.start();
        return document.add("__type__", (Object)property.getClass().getName()).add("__value__", (Object)property.toString()).get();
    }

    private BasicDBList toMap(Object property) {
        BasicDBList builder = new BasicDBList();
        Map map = (Map)property;
        builder.add((Object)property.getClass().getName());
        for (Map.Entry entry : map.entrySet()) {
            builder.add(this.toObject(entry.getKey()));
            builder.add(this.toObject(entry.getValue()));
        }
        return builder;
    }

    private BasicDBList toCollection(Object property) {
        BasicDBList builder = new BasicDBList();
        Collection collection = (Collection)property;
        builder.add((Object)property.getClass().getName());
        for (Object e : collection) {
            builder.add(this.toObject(e));
        }
        return builder;
    }

    private BasicDBList toArray(Object property) {
        BasicDBList builder = new BasicDBList();
        int length = Array.getLength(property);
        builder.add((Object)property.getClass().getName());
        for (int i = 0; i < length; ++i) {
            Object obj = this.toObject(Array.get(property, i));
            this.setArray(builder, obj);
        }
        return builder;
    }

    private void setArray(BasicDBList builder, Object obj) {
        if (obj == null) {
            builder.add(null);
            return;
        }
        switch (this.type(obj.getClass())) {
            case -124: {
                builder.add((Object)((Integer)obj));
                break;
            }
            case -120: {
                builder.add((Object)((Short)obj).intValue());
                break;
            }
            case -123: {
                builder.add((Object)((Long)obj));
                break;
            }
            case -121: {
                builder.add((Object)((Double)obj));
                break;
            }
            default: {
                builder.add(obj);
            }
        }
    }

    private Character toCharacter(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Character.valueOf(((String)value).charAt(0));
        }
        throw new IllegalArgumentException("invalid value for Character: " + value);
    }

    private Object fromSpecialType(DBObject value) {
        String type = (String)value.get("__type__");
        String val = (String)value.get("__value__");
        if (BigInteger.class.getName().equals(type)) {
            return new BigInteger(val);
        }
        if (BigDecimal.class.getName().equals(type)) {
            return new BigDecimal(val);
        }
        if (Byte.class.getName().equals(type)) {
            return Byte.valueOf(val);
        }
        if (Float.class.getName().equals(type)) {
            return Float.valueOf(val);
        }
        if (Character.class.getName().equals(type)) {
            return this.toCharacter(val);
        }
        if (Class.class.getName().equals(type)) {
            return this.toClass(val);
        }
        if (Locale.class.getName().equals(type)) {
            return this.toLocale(val);
        }
        if (URI.class.getName().equals(type)) {
            return URI.create(val);
        }
        if (Timestamp.class.getName().equals(type)) {
            return Timestamp.valueOf(val);
        }
        throw new IllegalArgumentException("unkown value: " + value);
    }

    private Locale toLocale(String str) {
        if (str == null) {
            return null;
        }
        String[] split = str.split("_");
        if (split.length == 0) {
            return new Locale("");
        }
        if (split.length == 1) {
            return new Locale(split[0]);
        }
        if (split.length == 2) {
            return new Locale(split[0], split[1]);
        }
        return new Locale(split[0], split[1], split[2]);
    }

    private Class toClass(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            try {
                return Class.forName((String)value);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalArgumentException(e);
            }
        }
        throw new IllegalArgumentException("invalid value for Character: " + value);
    }

    private DBObject toSpecialType(Object property) {
        BasicDBObjectBuilder document = BasicDBObjectBuilder.start();
        String toString = this.toString(property);
        return document.add("__type__", (Object)property.getClass().getName()).add("__value__", (Object)toString).get();
    }

    private String toString(Object property) {
        if (property instanceof Class) {
            return ((Class)property).getName();
        }
        return property.toString();
    }

    static {
        typeCodes.put(Boolean.class, (byte)-125);
        typeCodes.put(Byte.class, (byte)-127);
        typeCodes.put(Character.class, (byte)-128);
        typeCodes.put(Short.class, (byte)-120);
        typeCodes.put(Short.TYPE, (byte)-120);
        typeCodes.put(Integer.class, (byte)-124);
        typeCodes.put(Long.class, (byte)-123);
        typeCodes.put(Float.class, (byte)-122);
        typeCodes.put(Double.class, (byte)-121);
        typeCodes.put(String.class, (byte)-126);
        typeCodes.put(UUID.class, (byte)-119);
        typeCodes.put(Date.class, (byte)-118);
        typeCodes.put(BigInteger.class, (byte)-117);
        typeCodes.put(BigDecimal.class, (byte)-116);
        typeCodes.put(byte[].class, (byte)-115);
        typeCodes.put(ObjectId.class, (byte)122);
    }
}

