/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency.metadata;

import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.metadata.index.SpaceIndex;
import com.gigaspaces.metadata.index.SpaceIndexType;
import com.gigaspaces.persistency.MongoClientConnector;
import com.gigaspaces.sync.AddIndexData;
import com.mongodb.BasicDBObjectBuilder;
import com.mongodb.DBCollection;
import com.mongodb.DBObject;
import java.util.Map;

public class IndexBuilder {
    private final MongoClientConnector client;

    public IndexBuilder(MongoClientConnector client) {
        this.client = client;
    }

    public void ensureIndexes(SpaceTypeDescriptor spaceTypeDescriptor) {
        Map indexes = spaceTypeDescriptor.getIndexes();
        String id = spaceTypeDescriptor.getIdPropertyName();
        String routing = spaceTypeDescriptor.getRoutingPropertyName();
        for (SpaceIndex idx : indexes.values()) {
            if (idx.getIndexType() == SpaceIndexType.NONE || idx.getName().equals(id) || idx.getName().equals(routing)) continue;
            this.createIndex(spaceTypeDescriptor.getTypeName(), idx);
        }
        if (id != null && !id.equals(routing)) {
            this.createIndex(spaceTypeDescriptor.getTypeName(), routing, SpaceIndexType.EQUAL, BasicDBObjectBuilder.start());
        }
    }

    public void ensureIndexes(AddIndexData addIndexData) {
        for (SpaceIndex idx : addIndexData.getIndexes()) {
            if (idx.getIndexType() == SpaceIndexType.NONE) continue;
            this.createIndex(addIndexData.getTypeName(), idx);
        }
    }

    private void createIndex(String collectionName, SpaceIndex idx) {
        this.createIndex(collectionName, idx.getName(), idx.getIndexType(), BasicDBObjectBuilder.start());
    }

    private void createIndex(String typeSimpleName, String routing, SpaceIndexType type, BasicDBObjectBuilder option) {
        DBCollection c = this.client.getCollection(typeSimpleName);
        DBObject key = type == SpaceIndexType.BASIC || type == SpaceIndexType.EQUAL ? BasicDBObjectBuilder.start((String)routing, (Object)"hashed").get() : BasicDBObjectBuilder.start((String)routing, (Object)1).get();
        c.createIndex(key, option.get());
    }
}

