/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency.metadata;

import com.gigaspaces.internal.metadata.pojo.PojoPropertyInfo;
import com.gigaspaces.internal.metadata.pojo.PojoTypeInfo;
import com.gigaspaces.internal.metadata.pojo.PojoTypeInfoRepository;
import com.gigaspaces.persistency.error.SpaceMongoException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class PojoTypeDescriptor {
    private final Constructor<Object> constructor;
    private final Map<String, Method> getters = new HashMap<String, Method>();
    private final Map<String, Method> setters = new HashMap<String, Method>();

    public PojoTypeDescriptor(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException("type can not be null");
        }
        PojoTypeInfo typeInfo = PojoTypeInfoRepository.getPojoTypeInfo(type);
        try {
            this.constructor = type.getConstructor(new Class[0]);
        }
        catch (SecurityException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
        catch (NoSuchMethodException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
        for (PojoPropertyInfo property : typeInfo.getProperties().values()) {
            if ("class".equals(property.getName()) || property.getGetterMethod() == null || property.getSetterMethod() == null) continue;
            this.getters.put(property.getName(), property.getGetterMethod());
            this.setters.put(property.getName(), property.getSetterMethod());
        }
    }

    public Constructor<Object> getConstructor() {
        return this.constructor;
    }

    public Map<String, Method> getGetters() {
        return this.getters;
    }

    public Map<String, Method> getSetters() {
        return this.setters;
    }
}

