/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency.metadata;

import com.gigaspaces.document.SpaceDocument;
import com.gigaspaces.internal.reflection.ISetterMethod;
import com.gigaspaces.metadata.SpaceDocumentSupport;
import com.gigaspaces.metadata.SpaceTypeDescriptor;
import com.gigaspaces.persistency.error.SpaceMongoException;
import com.gigaspaces.persistency.metadata.MongoDocumentObjectConverter;
import com.gigaspaces.persistency.metadata.PojoRepository;
import com.gigaspaces.persistency.metadata.SpaceDocumentMapper;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.bson.types.ObjectId;

public class SpaceDocumentMapperImpl
implements SpaceDocumentMapper<DBObject> {
    private static final String _ID = "_id";
    private static final String TYPE = "__type__";
    private static final String VALUE = "__value__";
    private static final byte TYPE_CHAR = -128;
    private static final byte TYPE_BYTE = -127;
    private static final byte TYPE_STRING = -126;
    private static final byte TYPE_BOOLEAN = -125;
    private static final byte TYPE_INT = -124;
    private static final byte TYPE_LONG = -123;
    private static final byte TYPE_FLOAT = -122;
    private static final byte TYPE_DOUBLE = -121;
    private static final byte TYPE_SHORT = -120;
    private static final byte TYPE_UUID = -119;
    private static final byte TYPE_DATE = -118;
    private static final byte TYPE_BIGINT = -117;
    private static final byte TYPE_BIGDECIMAL = -116;
    private static final byte TYPE_BYTEARRAY = -115;
    private static final byte TYPE_ARRAY = 126;
    private static final byte TYPE_COLLECTION = 125;
    private static final byte TYPE_MAP = 124;
    private static final byte TYPE_ENUM = 123;
    private static final byte TYPE_OBJECTID = 122;
    private static final byte TYPE_OBJECT = 127;
    private static final Map<Class<?>, Byte> typeCodes = new HashMap();
    private PojoRepository repository = new PojoRepository();
    private SpaceTypeDescriptor spaceTypeDescriptor;

    public SpaceDocumentMapperImpl(SpaceTypeDescriptor spaceTypeDescriptor) {
        this.spaceTypeDescriptor = spaceTypeDescriptor;
    }

    private byte type(Object value) {
        Byte type = typeCodes.get(value instanceof Class ? value : value.getClass());
        if (type == null) {
            type = value.getClass().isEnum() ? Byte.valueOf((byte)123) : (value.getClass().isArray() ? Byte.valueOf((byte)126) : (Collection.class.isInstance(value) ? Byte.valueOf((byte)125) : (Map.class.isInstance(value) ? Byte.valueOf((byte)124) : Byte.valueOf((byte)127))));
        }
        return type;
    }

    private byte bsonType(Object value) {
        Byte type = typeCodes.get(value.getClass());
        if (type == null) {
            type = BasicDBList.class.isInstance(value) ? Byte.valueOf((byte)126) : Byte.valueOf((byte)127);
        }
        return type;
    }

    @Override
    public Object toDocument(DBObject bson) {
        if (bson == null) {
            return null;
        }
        String type = (String)bson.get(TYPE);
        if (this.isDocument(type)) {
            return this.toSpaceDocument(bson);
        }
        return this.toPojo(bson);
    }

    private Object toPojo(DBObject bson) {
        String className = (String)bson.get(TYPE);
        try {
            Class<?> type = this.getClassFor(className);
            Object pojo = this.repository.getConstructor(this.getClassFor(className)).newInstance();
            for (String property : bson.keySet()) {
                Object value;
                if (TYPE.equals(property) || (value = bson.get(property)) == null) continue;
                if (_ID.equals(property)) {
                    property = this.spaceTypeDescriptor.getIdPropertyName();
                }
                ISetterMethod<Object> setter = this.repository.getSetter(type, property);
                Object val = this.fromDBObject(value);
                setter.set(pojo, val);
            }
            return pojo;
        }
        catch (InvocationTargetException e) {
            throw new SpaceMongoException("can not invoke constructor or method: " + bson, e);
        }
        catch (InstantiationException e) {
            throw new SpaceMongoException("Could not find default constructor for: " + bson, e);
        }
        catch (IllegalAccessException e) {
            throw new SpaceMongoException("can not access constructor or method: " + bson, e);
        }
    }

    private Object toSpaceDocument(DBObject bson) {
        SpaceDocument document = new SpaceDocument((String)bson.get(TYPE));
        for (String property : bson.keySet()) {
            Object value;
            if (TYPE.equals(property) || (value = bson.get(property)) == null) continue;
            if (_ID.equals(property)) {
                property = this.spaceTypeDescriptor.getIdPropertyName();
            }
            document.setProperty(property, this.fromDBObject(value));
        }
        return document;
    }

    private boolean isDocument(String className) {
        try {
            Class.forName(className);
            return false;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return true;
        }
    }

    @Override
    public Object fromDBObject(Object value) {
        if (value == null) {
            return null;
        }
        switch (this.bsonType(value)) {
            case 122: {
                return null;
            }
            case 126: {
                return this.toExactArray((BasicDBList)value);
            }
            case 127: {
                return this.toExactObject(value);
            }
        }
        return value;
    }

    private Object toExactObject(Object value) {
        DBObject bson = (DBObject)value;
        if (bson.containsField(TYPE) && bson.containsField(VALUE)) {
            try {
                Class<?> type = Class.forName((String)bson.get(TYPE));
                if (type.isEnum()) {
                    return Enum.valueOf(type, (String)bson.get(VALUE));
                }
                return this.fromSpetialType((DBObject)value);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
        return this.toDocument(bson);
    }

    private Object toExactArray(BasicDBList value) {
        if (value.size() < 1) {
            throw new IllegalStateException("Illegal BSON array size: " + value.size() + ", size must be at lest 1");
        }
        Class<?> type = this.getClassFor((String)value.get(0));
        if (type.isArray()) {
            return this.toArray(type, value);
        }
        if (Collection.class.isAssignableFrom(type)) {
            return this.toCollection(type, value);
        }
        if (Map.class.isAssignableFrom(type)) {
            return this.toMap(type, value);
        }
        throw new SpaceMongoException("invalid Array/Collection/Map type: " + type.getName());
    }

    private Map toMap(Class<?> type, BasicDBList value) {
        Map map = null;
        try {
            map = (Map)this.repository.getConstructor(type).newInstance();
            for (int i = 1; i < value.size(); i += 2) {
                Object key = this.fromDBObject(value.get(i));
                Object val = this.fromDBObject(value.get(i + 1));
                map.put(key, val);
            }
            return map;
        }
        catch (InvocationTargetException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
        catch (InstantiationException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
    }

    private Object[] toArray(Class<?> type, BasicDBList value) {
        Object[] array = (Object[])Array.newInstance(type.getComponentType(), value.size() - 1);
        for (int i = 1; i < value.size(); ++i) {
            Object v = this.fromDBObject(value.get(i));
            if (SpaceDocument.class.isAssignableFrom(type.getComponentType())) {
                v = MongoDocumentObjectConverter.instance().toDocumentIfNeeded(v, SpaceDocumentSupport.CONVERT);
            }
            array[i - 1] = v;
        }
        return array;
    }

    private Collection toCollection(Class<?> type, BasicDBList value) {
        Collection collection = null;
        try {
            collection = (Collection)this.repository.getConstructor(type).newInstance();
            for (int i = 1; i < value.size(); ++i) {
                collection.add(this.fromDBObject(value.get(i)));
            }
        }
        catch (InvocationTargetException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
        catch (InstantiationException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
        catch (IllegalAccessException e) {
            throw new SpaceMongoException("Could not find default constructor for type: " + type.getName(), e);
        }
        return collection;
    }

    public Class<?> getClassFor(String type) {
        try {
            return Class.forName(type);
        }
        catch (ClassNotFoundException e) {
            throw new SpaceMongoException("Could not resolve type for type: " + type, e);
        }
    }

    @Override
    public DBObject toDBObject(Object document) {
        if (document == null) {
            return null;
        }
        if (document instanceof SpaceDocument) {
            return this.toDBObjectDocument((SpaceDocument)document);
        }
        return this.toDBObjectPojo(document);
    }

    private DBObject toDBObjectDocument(SpaceDocument document) {
        BasicDBObject bson = new BasicDBObject();
        Set keys = document.getProperties().keySet();
        bson.put(TYPE, (Object)document.getTypeName());
        for (String property : keys) {
            Object value = document.getProperty(property);
            if (value == null) continue;
            if (this.spaceTypeDescriptor.getIdPropertyName().equals(property)) {
                property = _ID;
            }
            bson.put(property, this.toObject(value));
        }
        return bson;
    }

    private DBObject toDBObjectPojo(Object pojo) {
        BasicDBObject bson = new BasicDBObject();
        Map<String, Method> getters = this.repository.getGetters(pojo.getClass());
        Class<?> type = pojo.getClass();
        bson.put(TYPE, (Object)type.getName());
        for (String property : getters.keySet()) {
            Object value = null;
            try {
                value = this.repository.getGetter(type, property).get(pojo);
                if (value == null) continue;
                if (this.spaceTypeDescriptor.getIdPropertyName().equals(property)) {
                    property = _ID;
                }
                bson.put(property, this.toObject(value));
            }
            catch (IllegalArgumentException e) {
                throw new SpaceMongoException("Argument is: " + value, e);
            }
            catch (IllegalAccessException e) {
                throw new SpaceMongoException("Can not access method", e);
            }
            catch (InvocationTargetException e) {
                throw new SpaceMongoException("Can not invoke method", e);
            }
        }
        return bson;
    }

    @Override
    public Object toObject(Object property) {
        switch (this.type(property)) {
            case -128: 
            case -127: 
            case -122: 
            case -117: 
            case -116: {
                return this.toSpectialType(property);
            }
            case 127: {
                SpaceDocument document = MongoDocumentObjectConverter.instance().toSpaceDocument(property);
                return this.toDBObject(document);
            }
            case 123: {
                return this.toEnum(property);
            }
            case 126: {
                return this.toArray(property);
            }
            case 125: {
                return this.toCollection(property);
            }
            case 124: {
                return this.toMap(property);
            }
        }
        return property;
    }

    private Object toEnum(Object property) {
        return new BasicDBObject(TYPE, (Object)property.getClass().getName()).append(VALUE, (Object)property.toString());
    }

    private BasicDBList toMap(Object property) {
        BasicDBList list = new BasicDBList();
        Map map = (Map)property;
        int index = 0;
        list.add(index++, (Object)property.getClass().getName());
        for (Map.Entry entry : map.entrySet()) {
            list.add(index++, this.toObject(entry.getKey()));
            list.add(index++, this.toObject(entry.getValue()));
        }
        return list;
    }

    private BasicDBList toCollection(Object property) {
        BasicDBList list = new BasicDBList();
        Collection collection = (Collection)property;
        int index = 0;
        list.add(index++, (Object)property.getClass().getName());
        for (Object e : collection) {
            list.add(index++, this.toObject(e));
        }
        return list;
    }

    private BasicDBList toArray(Object property) {
        BasicDBList list = new BasicDBList();
        Object[] array = (Object[])property;
        list.add(0, (Object)property.getClass().getName());
        for (int i = 0; i < array.length; ++i) {
            list.add(i + 1, this.toObject(array[i]));
        }
        return list;
    }

    private Character toCharacter(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return Character.valueOf(((String)value).charAt(0));
        }
        throw new IllegalArgumentException("invalid value for Character: " + value);
    }

    private Object fromSpetialType(DBObject value) {
        String type = (String)value.get(TYPE);
        String val = (String)value.get(VALUE);
        if (BigInteger.class.getName().equals(type)) {
            return new BigInteger(val);
        }
        if (BigDecimal.class.getName().equals(type)) {
            return new BigDecimal(val);
        }
        if (Byte.class.getName().equals(type)) {
            return Byte.valueOf(val);
        }
        if (Float.class.getName().equals(type)) {
            return Float.valueOf(val);
        }
        if (Character.class.getName().equals(type)) {
            return this.toCharacter(val);
        }
        throw new IllegalArgumentException("unkown value: " + value);
    }

    private DBObject toSpectialType(Object property) {
        return new BasicDBObject(TYPE, (Object)property.getClass().getName()).append(VALUE, (Object)property.toString());
    }

    static {
        typeCodes.put(Boolean.class, (byte)-125);
        typeCodes.put(Byte.class, (byte)-127);
        typeCodes.put(Character.class, (byte)-128);
        typeCodes.put(Short.class, (byte)-120);
        typeCodes.put(Integer.class, (byte)-124);
        typeCodes.put(Long.class, (byte)-123);
        typeCodes.put(Float.class, (byte)-122);
        typeCodes.put(Double.class, (byte)-121);
        typeCodes.put(String.class, (byte)-126);
        typeCodes.put(UUID.class, (byte)-119);
        typeCodes.put(Date.class, (byte)-118);
        typeCodes.put(BigInteger.class, (byte)-117);
        typeCodes.put(BigDecimal.class, (byte)-116);
        typeCodes.put(byte[].class, (byte)-115);
        typeCodes.put(ObjectId.class, (byte)122);
    }
}

