/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.persistency.parser;

import com.gigaspaces.persistency.parser.SQL2MongoParser;
import com.gigaspaces.persistency.parser.SQL2MongoVisitor;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.QueryBuilder;
import java.util.LinkedList;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import org.antlr.v4.runtime.ParserRuleContext;
import org.antlr.v4.runtime.tree.AbstractParseTreeVisitor;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.RuleNode;
import org.bson.BSONObject;

public class SQL2MongoBaseVisitor<T>
extends AbstractParseTreeVisitor<T>
implements SQL2MongoVisitor<T> {
    private static final String RLIKE = "rlike()";
    private static final String LIKE = "like()";
    private static final String PARAMETER_PLACEHOLDER = "'%{}'";
    private static final Pattern stringPattern = Pattern.compile("'[^']*'");
    private static final Pattern booleanPattern = Pattern.compile("(true|false)");
    private static final Pattern numberPattern = Pattern.compile("[0-9\\.]+");
    private DBObject query;
    private final Stack<String> stack = new Stack();
    private QueryBuilder atom = QueryBuilder.start();
    private final LinkedList<DBObject> ands = new LinkedList();
    private final LinkedList<DBObject> ors = new LinkedList();

    public SQL2MongoBaseVisitor() {
        this.query = new BasicDBObject();
    }

    @Override
    public T visitNot(SQL2MongoParser.NotContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    public DBObject getQuery() {
        return this.query;
    }

    @Override
    public T visitExpression(SQL2MongoParser.ExpressionContext ctx) {
        return (T)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public T visitAtom(SQL2MongoParser.AtomContext ctx) {
        if (ctx.getChildCount() > 0) {
            String id = ctx.getChild(0).getText();
            this.stack.push(id);
        }
        return (T)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public T visitOp(SQL2MongoParser.OpContext ctx) {
        String op = ctx.getText();
        this.stack.push(op);
        return (T)this.visitChildren((RuleNode)ctx);
    }

    @Override
    public T visitOr(SQL2MongoParser.OrContext ctx) {
        Object r = this.visitChildren((RuleNode)ctx);
        if (this.IsLogic(ctx, "OR")) {
            QueryBuilder q = QueryBuilder.start();
            for (DBObject at : this.ands) {
                q.or(new DBObject[]{at});
            }
            Set keys = this.atom.get().keySet();
            for (String key : keys) {
                q.or(new DBObject[]{new BasicDBObject(key, this.atom.get().get(key))});
            }
            this.ands.clear();
            this.atom = QueryBuilder.start();
            this.ors.add(q.get());
        }
        return (T)r;
    }

    @Override
    public T visitValue(SQL2MongoParser.ValueContext ctx) {
        Object r = this.visitChildren((RuleNode)ctx);
        String op = this.stack.pop();
        String id = this.stack.pop();
        String val = ctx.getChild(0).getText();
        this.atom.and(id);
        if ("is".equals(op)) {
            this.buildIsExpression(val, this.atom);
        } else if ("like".equals(op)) {
            this.atom.regex(Pattern.compile(LIKE));
        } else if ("rlike".equals(op)) {
            this.atom.regex(Pattern.compile(RLIKE));
        } else if ("!=".equals(op)) {
            this.atom.notEquals((Object)PARAMETER_PLACEHOLDER);
        } else if ("=".equals(op)) {
            this.atom.is(this.evaluate(val));
        } else if (">=".equals(op)) {
            this.atom.greaterThanEquals((Object)PARAMETER_PLACEHOLDER);
        } else if ("<=".equals(op)) {
            this.atom.lessThanEquals((Object)PARAMETER_PLACEHOLDER);
        } else if ("<".equals(op)) {
            this.atom.lessThan((Object)PARAMETER_PLACEHOLDER);
        } else if (">".equals(op)) {
            this.atom.greaterThan((Object)PARAMETER_PLACEHOLDER);
        }
        return (T)r;
    }

    private Object evaluate(String val) {
        if (val == null || val.isEmpty()) {
            return null;
        }
        if ("?".equals(val)) {
            return PARAMETER_PLACEHOLDER;
        }
        boolean isValue = stringPattern.matcher(val).matches();
        if (isValue) {
            return val.substring(1, val.length() - 1);
        }
        isValue = booleanPattern.matcher(val).matches();
        if (isValue) {
            return Boolean.valueOf(val);
        }
        isValue = numberPattern.matcher(val).matches();
        if (isValue) {
            int floatIndex = val.indexOf(46);
            if (floatIndex > -1) {
                return Double.valueOf(val);
            }
            return Long.valueOf(val);
        }
        throw new IllegalArgumentException(val);
    }

    @Override
    public T visitParse(SQL2MongoParser.ParseContext ctx) {
        Object r = this.visitChildren((RuleNode)ctx);
        for (DBObject o : this.ors) {
            this.query.putAll((BSONObject)o);
        }
        for (DBObject o : this.ands) {
            this.query.putAll((BSONObject)o);
        }
        DBObject o = this.atom.get();
        if (o.keySet().size() > 0) {
            this.query.putAll((BSONObject)o);
        }
        return (T)r;
    }

    @Override
    public T visitAnd(SQL2MongoParser.AndContext ctx) {
        Object r = this.visitChildren((RuleNode)ctx);
        if (this.IsLogic(ctx, "AND")) {
            this.ands.add(this.atom.get());
            this.atom = QueryBuilder.start();
        }
        return (T)r;
    }

    private boolean IsLogic(ParserRuleContext ctx, String text) {
        for (int i = 0; i < ctx.getChildCount(); ++i) {
            ParseTree c = ctx.getChild(i);
            if (!c.getText().equals(text)) continue;
            return true;
        }
        return false;
    }

    private void buildIsExpression(String val, QueryBuilder subQuery) {
        int index = val.indexOf("NOT");
        subQuery.exists((Object)(index <= -1 ? 1 : 0));
    }
}

