/*
 * Decompiled with CFR 0.152.
 */
package org.openspaces.remoting.scripting;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.jruby.Ruby;
import org.jruby.ast.Node;
import org.jruby.internal.runtime.GlobalVariables;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaEmbedUtils;
import org.jruby.javasupport.JavaUtil;
import org.jruby.runtime.Block;
import org.jruby.runtime.GlobalVariable;
import org.jruby.runtime.IAccessor;
import org.jruby.runtime.builtin.IRubyObject;
import org.openspaces.remoting.scripting.AbstractLocalScriptExecutor;
import org.openspaces.remoting.scripting.Script;
import org.openspaces.remoting.scripting.ScriptCompilationException;
import org.openspaces.remoting.scripting.ScriptExecutionException;

public class JRubyLocalScriptExecutor
extends AbstractLocalScriptExecutor<JRubyCompiledScript> {
    public JRubyCompiledScript doCompile(Script script) throws ScriptCompilationException {
        Ruby runtime = JavaEmbedUtils.initialize(new ArrayList());
        IRubyObject rubyScript = JavaEmbedUtils.javaToRuby((Ruby)runtime, (Object)script.getScriptAsString());
        try {
            Node node = runtime.parse(rubyScript.asSymbol(), "<unknown>", null, 0);
            return new JRubyCompiledScript(runtime, node);
        }
        catch (Exception e) {
            throw new ScriptExecutionException("Failed to execute script [" + script.getName() + "]", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object execute(Script script, JRubyCompiledScript compiledScript, Map<String, Object> parameters) throws ScriptExecutionException {
        GlobalVariables globablVariables = compiledScript.runtime.getGlobalVariables();
        if (parameters != null) {
            compiledScript.runtime.setGlobalVariables((GlobalVariables)new ParametersGlobalVariables(compiledScript.runtime, parameters));
        }
        try {
            Object object = this.rubyToJava(compiledScript.runtime.eval(compiledScript.node));
            return object;
        }
        finally {
            compiledScript.runtime.setGlobalVariables(globablVariables);
        }
    }

    public void close(JRubyCompiledScript compiledScript) {
        JavaEmbedUtils.terminate((Ruby)compiledScript.runtime);
    }

    public boolean isThreadSafe() {
        return false;
    }

    private Object rubyToJava(IRubyObject value) {
        return this.rubyToJava(value, Object.class);
    }

    private Object rubyToJava(IRubyObject value, Class type) {
        return JavaUtil.convertArgument((Object)Java.ruby_to_java((IRubyObject)value, (IRubyObject)value, (Block)Block.NULL_BLOCK), (Class)type);
    }

    private class ParametersGlobalVariables
    extends GlobalVariables {
        private Ruby runtime;
        private Map<String, Object> parameters;
        GlobalVariables parent;

        public ParametersGlobalVariables(Ruby runtime, Map<String, Object> parameters) {
            super(runtime);
            this.runtime = runtime;
            this.parameters = parameters;
            this.parent = runtime.getGlobalVariables();
        }

        public void define(String name, IAccessor accessor) {
            this.parameters.put(name, new GlobalVariable(this.runtime, name, accessor.getValue()));
        }

        public void defineReadonly(String name, IAccessor accessor) {
            this.parameters.put(name, new GlobalVariable(this.runtime, name, accessor.getValue()));
        }

        public boolean isDefined(String name) {
            String modifiedName = name.substring(1);
            boolean defined = this.parameters.containsKey(modifiedName);
            return defined || this.parent.isDefined(name);
        }

        public void alias(String name, String oldName) {
            if (this.runtime.getSafeLevel() >= 4) {
                throw this.runtime.newSecurityError("Insecure: can't alias global variable");
            }
            IRubyObject value = this.get(oldName);
            this.parameters.put(name, JRubyLocalScriptExecutor.this.rubyToJava(value));
        }

        public IRubyObject get(String name) {
            String modifiedName = name.substring(1);
            Object obj = this.parameters.get(modifiedName);
            if (obj instanceof IAccessor) {
                return ((IAccessor)obj).getValue();
            }
            return JavaEmbedUtils.javaToRuby((Ruby)this.runtime, (Object)obj);
        }

        public IRubyObject set(String name, IRubyObject value) {
            if (this.runtime.getSafeLevel() >= 4) {
                throw this.runtime.newSecurityError("Insecure: can't change global variable value");
            }
            String modifiedName = name.substring(1);
            IRubyObject oldValue = this.get(name);
            Object obj = this.parameters.get(modifiedName);
            if (obj instanceof IAccessor) {
                ((IAccessor)obj).setValue(value);
            } else {
                this.parameters.put(modifiedName, JRubyLocalScriptExecutor.this.rubyToJava(value));
            }
            return oldValue;
        }

        public Iterator getNames() {
            ArrayList<String> list = new ArrayList<String>();
            for (String key : this.parameters.keySet()) {
                list.add(key);
            }
            Iterator names = this.parent.getNames();
            while (names.hasNext()) {
                list.add((String)names.next());
            }
            return Collections.unmodifiableList(list).iterator();
        }
    }

    public static class JRubyCompiledScript {
        public Ruby runtime;
        public Node node;

        private JRubyCompiledScript(Ruby runtime, Node node) {
            this.runtime = runtime;
            this.node = node;
        }
    }
}

