/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.audit;

import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.AuthenticationToken;
import com.gigaspaces.security.audit.AuditDetails;
import com.gigaspaces.security.audit.AuditHandler;
import com.gigaspaces.security.audit.AuditLogRecord;
import com.gigaspaces.security.audit.SecurityAudit;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.service.SecurityContext;
import com.gigaspaces.security.session.SessionDetails;
import java.util.logging.Filter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LoggerSecurityAudit
implements SecurityAudit {
    public static final Logger auditLogger = Logger.getLogger(LoggerSecurityAudit.class.getPackage().getName());

    public LoggerSecurityAudit() {
        try {
            Handler[] handlers;
            String handlerClassName;
            LogManager manager = LogManager.getLogManager();
            String auditEnabled = this.resolveLoggerProperty(manager, auditLogger.getName() + ".enabled");
            if (!Boolean.parseBoolean(auditEnabled)) {
                auditLogger.setFilter(new Filter(){

                    @Override
                    public boolean isLoggable(LogRecord record) {
                        return false;
                    }
                });
                auditLogger.setLevel(Level.OFF);
                return;
            }
            String auditLevel = this.resolveLoggerProperty(manager, auditLogger.getName() + ".level");
            if (auditLevel == null) {
                auditLogger.setLevel(Level.OFF);
            }
            if ((handlerClassName = this.resolveLoggerProperty(manager, auditLogger.getName() + ".handler")) == null) {
                handlerClassName = AuditHandler.class.getName();
            }
            Handler auditHandler = Thread.currentThread().getContextClassLoader().loadClass(handlerClassName).asSubclass(Handler.class).newInstance();
            for (Handler handler : handlers = auditLogger.getHandlers()) {
                auditLogger.removeHandler(handler);
            }
            auditLogger.addHandler(auditHandler);
            auditLogger.setUseParentHandlers(false);
        }
        catch (Exception e) {
            auditLogger.log(Level.SEVERE, "Failed to create audit log file - turning auditing OFF", e);
            auditLogger.setLevel(Level.OFF);
        }
    }

    private String resolveLoggerProperty(LogManager manager, String propertyKey) {
        return System.getProperty(propertyKey, manager.getProperty(propertyKey));
    }

    public void authenticationFailed(SecurityContext securityContext, AuthenticationException authenticationException) {
        if (!auditLogger.isLoggable(Level.SEVERE)) {
            return;
        }
        AuditDetails auditDetails = securityContext.getAuditDetails();
        AuditLogRecord record = new AuditLogRecord(Level.SEVERE, auditLogger.getName(), "Authentication failed; " + authenticationException.getMessage() + " from host [" + auditDetails.getHost() + "]");
        record.setAuditDetails(auditDetails);
        record.setException((Exception)authenticationException);
        auditLogger.log(record);
    }

    public void authenticationSuccessful(SecurityContext in, SecurityContext out) {
        if (!auditLogger.isLoggable(Level.INFO)) {
            return;
        }
        AuditDetails auditDetails = in.getAuditDetails();
        AuditLogRecord record = new AuditLogRecord(Level.INFO, auditLogger.getName(), "Authentication successful; for user [" + in.getUserDetails().getUsername() + "] from host [" + auditDetails.getHost() + "]; session-id [" + out.getAuthenticationToken().hashCode() + "]");
        record.setAuditDetails(auditDetails);
        record.setUsername(in.getUserDetails().getUsername());
        record.setSessionId(String.valueOf(out.getAuthenticationToken().hashCode()));
        auditLogger.log(record);
    }

    public void authenticationInvalid(AuthenticationToken token) {
        if (!auditLogger.isLoggable(Level.SEVERE)) {
            return;
        }
        AuditLogRecord record = new AuditLogRecord(Level.SEVERE, auditLogger.getName(), "Authentication session invalid; session-id [" + token.hashCode() + "]");
        record.setSessionId(String.valueOf(token.hashCode()));
        auditLogger.log(record);
    }

    public void accessDenied(SecurityContext securityContext, SessionDetails sessionDetails, Privilege privilege, String className) {
        if (!auditLogger.isLoggable(Level.WARNING)) {
            return;
        }
        AuditDetails auditDetails = sessionDetails.getAuditDetails();
        Authentication authentication = sessionDetails.getAuthentication();
        AuditLogRecord record = new AuditLogRecord(Level.WARNING, auditLogger.getName(), "Access denied; user [" + authentication.getUserDetails().getUsername() + "] at host [" + auditDetails.getHost() + "] lacks [" + privilege + "] privileges for class [" + className + "]; session-id [" + securityContext.getAuthenticationToken().hashCode() + "]");
        record.setAuditDetails(auditDetails);
        record.setUsername(authentication.getUserDetails().getUsername());
        record.setSessionId(String.valueOf(securityContext.getAuthenticationToken().hashCode()));
        record.setPrivilege(String.valueOf(privilege));
        record.setFilter(className);
        auditLogger.log(record);
    }

    public void accessGranted(SecurityContext securityContext, SessionDetails sessionDetails, Privilege privilege, String className) {
        if (!auditLogger.isLoggable(Level.FINE)) {
            return;
        }
        AuditDetails auditDetails = sessionDetails.getAuditDetails();
        Authentication authentication = sessionDetails.getAuthentication();
        AuditLogRecord record = new AuditLogRecord(Level.FINE, auditLogger.getName(), "Access granted; user [" + authentication.getUserDetails().getUsername() + "] at host [" + auditDetails.getHost() + "] has [" + privilege + "] privileges for class [" + className + "]; session-id [" + securityContext.getAuthenticationToken().hashCode() + "]");
        record.setAuditDetails(auditDetails);
        record.setUsername(authentication.getUserDetails().getUsername());
        record.setSessionId(String.valueOf(securityContext.getAuthenticationToken().hashCode()));
        record.setPrivilege(String.valueOf(privilege));
        record.setFilter(className);
        auditLogger.log(record);
    }
}

