/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.fs;

import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.directory.DirectoryManager;
import com.gigaspaces.security.directory.RoleManager;
import com.gigaspaces.security.directory.UserManager;
import com.gigaspaces.security.fs.FileRoleManager;
import com.gigaspaces.security.fs.FileServiceAccessor;
import com.gigaspaces.security.fs.FileUserManager;
import java.io.IOException;

public class FileDirectoryManager
implements DirectoryManager {
    private final RoleManager roleManager;
    private final UserManager userManager;
    private final FileServiceAccessor fileServiceAccessor;

    public FileDirectoryManager(FileServiceAccessor fileServiceAccessor, boolean manageRolePrivileges, boolean manageUserPrivileges) {
        this.fileServiceAccessor = fileServiceAccessor;
        this.roleManager = new FileRoleManager(fileServiceAccessor, !manageRolePrivileges);
        this.userManager = new FileUserManager(fileServiceAccessor, !manageUserPrivileges);
    }

    public RoleManager getRoleManager() {
        return this.roleManager;
    }

    public UserManager getUserManager() {
        return this.userManager;
    }

    public void close() {
        try {
            this.fileServiceAccessor.close();
        }
        catch (IOException e) {
            throw new SecurityException("Failed to close the directory manager", (Throwable)e);
        }
    }
}

