/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.fs;

import com.gigaspaces.security.encoding.ContentEncoder;
import com.gigaspaces.security.encoding.EncodingException;
import com.gigaspaces.security.encoding.PasswordEncoder;
import com.gigaspaces.security.encoding.aes.AesContentEncoder;
import com.gigaspaces.security.encoding.md5.Md5PasswordEncoder;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileEncodingManager {
    private static final Logger logger = Logger.getLogger(FileEncodingManager.class.getPackage().getName());
    public static final String PASSWORD_ENCODER_CLASS_PROPERTY_KEY = "com.gs.security.fs.password-encoder.class";
    public static final String CONTENT_ENCODER_CLASS_PROPERTY_KEY = "com.gs.security.fs.content-encoder.class";
    private final PasswordEncoder passwordEncoder;
    private final ContentEncoder contentEncoder;

    public FileEncodingManager(Properties properties) {
        this.passwordEncoder = this.createPasswordEncoder(properties);
        this.contentEncoder = this.createContentEncoder(properties);
    }

    private PasswordEncoder createPasswordEncoder(Properties properties) throws EncodingException {
        String property;
        if (logger.isLoggable(Level.CONFIG) && (property = properties.getProperty(PASSWORD_ENCODER_CLASS_PROPERTY_KEY)) != null) {
            logger.config("Security password-encoder class: " + property);
        }
        try {
            String classname = properties.getProperty(PASSWORD_ENCODER_CLASS_PROPERTY_KEY, Md5PasswordEncoder.class.getName()).trim();
            Class<PasswordEncoder> passwordEncoderClass = Class.forName(classname).asSubclass(PasswordEncoder.class);
            PasswordEncoder newInstance = passwordEncoderClass.newInstance();
            return newInstance;
        }
        catch (Exception e) {
            throw new EncodingException("Failed to create PasswordEncoder", (Throwable)e);
        }
    }

    private ContentEncoder createContentEncoder(Properties properties) throws EncodingException {
        String property;
        if (logger.isLoggable(Level.CONFIG) && (property = properties.getProperty(CONTENT_ENCODER_CLASS_PROPERTY_KEY)) != null) {
            logger.config("Security content-encoder class: " + property);
        }
        try {
            String classname = properties.getProperty(CONTENT_ENCODER_CLASS_PROPERTY_KEY, AesContentEncoder.class.getName()).trim();
            Class<ContentEncoder> contentEncoderClass = Class.forName(classname).asSubclass(ContentEncoder.class);
            ContentEncoder newInstance = contentEncoderClass.newInstance();
            return newInstance;
        }
        catch (Exception e) {
            throw new EncodingException("Failed to create ContentEncoder", (Throwable)e);
        }
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public ContentEncoder getContentEncoder() {
        return this.contentEncoder;
    }
}

