/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.fs;

import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.Authority;
import com.gigaspaces.security.authorities.RoleAuthority;
import com.gigaspaces.security.directory.RoleAlreadyExistsException;
import com.gigaspaces.security.directory.RoleDataAccessException;
import com.gigaspaces.security.directory.RoleDetails;
import com.gigaspaces.security.directory.RoleManager;
import com.gigaspaces.security.directory.RoleNotFoundException;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.fs.FileServiceAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;

public class FileRoleManager
implements RoleManager {
    private final FileServiceAccessor fileServiceAccessor;
    private final boolean isReadOnly;

    public FileRoleManager(FileServiceAccessor fileServiceAccessor, boolean isReadOnly) {
        this.fileServiceAccessor = fileServiceAccessor;
        this.isReadOnly = isReadOnly;
    }

    public boolean isReadOnly() {
        return this.isReadOnly;
    }

    public void createRole(RoleDetails roleDetails) throws RoleAlreadyExistsException, RoleDataAccessException, AccessDeniedException {
        if (this.isReadOnly()) {
            throw new AccessDeniedException("Insufficient privileges for creating roles; Read-only operations allowed");
        }
        if (this.roleExists(roleDetails.getRole())) {
            throw new RoleAlreadyExistsException("Could not create non-unique role: " + roleDetails.getRole());
        }
        this.fileServiceAccessor.getFileContent().getRoleDetails().put(roleDetails.getRole(), roleDetails);
        this.fileServiceAccessor.getFileContent().setModified(true);
    }

    public void deleteRole(String role) throws RoleNotFoundException, RoleDataAccessException, AccessDeniedException {
        if (this.isReadOnly()) {
            throw new AccessDeniedException("Insufficient privileges for deleting roles; Read-only operations allowed");
        }
        RoleDetails removed = this.fileServiceAccessor.getFileContent().getRoleDetails().remove(role);
        if (removed == null) {
            throw new RoleNotFoundException("Could not delete role: " + role);
        }
        this.deleteRoleFromUsers(removed);
        this.fileServiceAccessor.getFileContent().setModified(true);
    }

    private void deleteRoleFromUsers(RoleDetails removed) {
        Map<String, UserDetails> userDetails = this.fileServiceAccessor.getFileContent().getUserDetails();
        for (UserDetails user : userDetails.values()) {
            if (!(user instanceof User)) continue;
            ArrayList<Authority> asList = new ArrayList<Authority>(Arrays.asList(user.getAuthorities()));
            Iterator iterator = asList.iterator();
            while (iterator.hasNext()) {
                Authority authority = (Authority)iterator.next();
                if (!(authority instanceof RoleAuthority) || !((RoleAuthority)authority).getRole().equals(removed.getRole())) continue;
                iterator.remove();
            }
            if (asList.size() == user.getAuthorities().length) continue;
            User updated = new User(user.getUsername(), user.getPassword(), asList.toArray(new Authority[asList.size()]));
            userDetails.put(user.getUsername(), (UserDetails)updated);
        }
    }

    public RoleDetails getRole(String role) throws RoleNotFoundException, RoleDataAccessException {
        RoleDetails roleDetails = this.fileServiceAccessor.getFileContent().getRoleDetails().get(role);
        if (roleDetails == null) {
            throw new RoleNotFoundException("Could not find role: " + role);
        }
        return roleDetails;
    }

    public Map<String, RoleDetails> mapRoles() throws RoleDataAccessException {
        return Collections.unmodifiableMap(this.fileServiceAccessor.getFileContent().getRoleDetails());
    }

    public boolean roleExists(String role) throws RoleDataAccessException {
        return this.fileServiceAccessor.getFileContent().getRoleDetails().containsKey(role);
    }

    public void updateRole(RoleDetails roleDetails) throws RoleNotFoundException, RoleDataAccessException, AccessDeniedException {
        if (this.isReadOnly()) {
            throw new AccessDeniedException("Insufficient privileges for updating roles; Read-only operations allowed");
        }
        if (!this.roleExists(roleDetails.getRole())) {
            throw new RoleNotFoundException("Could not update role: " + roleDetails.getRole());
        }
        this.fileServiceAccessor.getFileContent().getRoleDetails().put(roleDetails.getRole(), roleDetails);
        this.fileServiceAccessor.getFileContent().setModified(true);
    }
}

