/*
 * Decompiled with CFR 0.152.
 */
package com.gigaspaces.security.fs;

import com.gigaspaces.security.AccessDeniedException;
import com.gigaspaces.security.Authentication;
import com.gigaspaces.security.AuthenticationException;
import com.gigaspaces.security.Authority;
import com.gigaspaces.security.SecurityException;
import com.gigaspaces.security.SecurityManager;
import com.gigaspaces.security.authorities.Privilege;
import com.gigaspaces.security.authorities.SystemAuthority;
import com.gigaspaces.security.directory.DirectoryManager;
import com.gigaspaces.security.directory.User;
import com.gigaspaces.security.directory.UserDetails;
import com.gigaspaces.security.directory.UserManager;
import com.gigaspaces.security.fs.FileDirectoryManager;
import com.gigaspaces.security.fs.FileEncodingManager;
import com.gigaspaces.security.fs.FileService;
import com.gigaspaces.security.fs.FileServiceAccessor;
import com.gigaspaces.security.fs.LocalFileService;
import java.io.IOException;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FileSecurityManager
implements SecurityManager {
    private static final Logger logger = Logger.getLogger(FileSecurityManager.class.getPackage().getName());
    public static final String ADMIN = "admin";
    private FileEncodingManager fileEncodingManager;
    private Properties properties;
    private FileService fileService;
    private FileServiceAccessor fileServiceAccessor;

    public Authentication authenticate(UserDetails userDetails) throws AuthenticationException {
        try {
            UserDetails user = this.fileServiceAccessor.loadUserByUsername(userDetails.getUsername());
            boolean valid = this.fileEncodingManager.getPasswordEncoder().isPasswordValid(user.getPassword(), userDetails.getPassword());
            if (!valid) {
                throw new AuthenticationException("Authentication failed for user [" + userDetails.getUsername() + "]");
            }
            return new Authentication(user);
        }
        catch (SecurityException se) {
            throw new AuthenticationException("Authentication request is invalid for user [" + userDetails.getUsername() + "]", (Throwable)se);
        }
        catch (Exception e) {
            throw new AuthenticationException((Throwable)e);
        }
    }

    public DirectoryManager createDirectoryManager(UserDetails userDetails) throws AuthenticationException, AccessDeniedException {
        if (!this.fileService.fileExists()) {
            FileDirectoryManager directoryManager = new FileDirectoryManager(this.fileServiceAccessor, true, true);
            UserManager userManager = directoryManager.getUserManager();
            userManager.createUser((UserDetails)new User(ADMIN, ADMIN, new Authority[]{new SystemAuthority(SystemAuthority.SystemPrivilege.MANAGE_ROLES), new SystemAuthority(SystemAuthority.SystemPrivilege.MANAGE_USERS)}));
            directoryManager.close();
        }
        Authentication authentication = this.authenticate(userDetails);
        boolean manageRolePrivileges = authentication.getGrantedAuthorities().isGranted((Privilege)SystemAuthority.SystemPrivilege.MANAGE_ROLES);
        boolean manageUserPrivileges = authentication.getGrantedAuthorities().isGranted((Privilege)SystemAuthority.SystemPrivilege.MANAGE_USERS);
        if (!manageRolePrivileges && !manageUserPrivileges) {
            throw new AccessDeniedException("User [" + userDetails.getUsername() + "] lacks [" + SystemAuthority.SystemPrivilege.MANAGE_ROLES + " / " + SystemAuthority.SystemPrivilege.MANAGE_USERS + "] privileges");
        }
        FileDirectoryManager directoryManager = new FileDirectoryManager(this.fileServiceAccessor, manageRolePrivileges, manageUserPrivileges);
        return directoryManager;
    }

    public void close() {
        try {
            this.fileServiceAccessor.close();
        }
        catch (IOException e) {
            throw new SecurityException("Failed to close the security manager", (Throwable)e);
        }
    }

    public void init(Properties properties) throws SecurityException {
        this.properties = properties;
        try {
            this.fileEncodingManager = new FileEncodingManager(properties);
            this.fileService = this.createFileService();
            this.fileServiceAccessor = new FileServiceAccessor(this.fileService, this.fileEncodingManager);
        }
        catch (Exception e) {
            throw new SecurityException("Failed to initialize", (Throwable)e);
        }
    }

    private FileService createFileService() throws Exception {
        String property;
        if (logger.isLoggable(Level.CONFIG) && (property = this.properties.getProperty("com.gs.security.fs.file-service.class")) != null) {
            logger.config("Security file-service class: " + property);
        }
        String classname = this.properties.getProperty("com.gs.security.fs.file-service.class", LocalFileService.class.getName()).trim();
        Class<FileService> fileServiceClass = Class.forName(classname).asSubclass(FileService.class);
        FileService fileService = fileServiceClass.newInstance();
        fileService.init(this.properties);
        return fileService;
    }
}

